#include <iostream>
#include <queue>

#define MAX_N 100000

bool visited[MAX_N];
std::vector <std::pair <int, int>> v[MAX_N];

int a[MAX_N];
int b[MAX_N];
int c[MAX_N];
int n, m;

bool is_acyclic(int start_ind) {
    visited[start_ind] = true;
    for (auto p: v[start_ind]) {
        if (p.second != 0) continue;
        if (visited[p.first]) return false;
        is_acyclic(p.first);
    }
    
    return true;
}

int main() {
    std::cin >> n >> m;

    for (int i = 0; i < m; i++) {
        std::cin >> a[i] >> b[i] >> c[i];
        v[a[i]].push_back({ b[i], c[i] });
    }

    for (int i = 0; i < n; i++) visited[i] = false;
    for (int i = 0; i < n; i++) {
        if (visited[i]) break;
        if (!is_acyclic(i)) {
            std::cout << 1;
            return 0;
        }
    }
    std::cout << 0;
}