#include <iostream>
#include <queue>

#define MAX_N 100000

bool visited[MAX_N];
std::vector <std::pair <int, int>> v[MAX_N];

int a[MAX_N];
int b[MAX_N];
int c[MAX_N];
int n, m;

bool is_acyclic(int start_ind) {
    std::queue <int> q;
    q.push(start_ind); visited[start_ind] = true;

    while (!q.empty()) {
        int curr_elem = q.front(); q.pop();
        visited[curr_elem] = true;

        for (auto p: v[curr_elem]) {
            if (p.second != 0) continue;
            if (visited[p.first]) return false;
            q.push(p.first);
        }
    }

    return true;
}

bool is_acyclic() {
    for (int i = 0; i < n; i++) {
        if (visited[i]) break;
        if (!is_acyclic(i)) return false;
    }

    return true;
}

int main() {
    std::cin >> n >> m;

    for (int i = 0; i < m; i++) {
        std::cin >> a[i] >> b[i] >> c[i];
        v[a[i]].push_back({ b[i], c[i] });
    }

    std::cout << !is_acyclic();
}