#include <iostream>
#include <vector>
#include <queue>
#include <algorithm>

#define MAX_N 1000000

int n, k;
std::vector <int> v[MAX_N];
int dists[MAX_N];
int from[MAX_N];

bool p[100][1000];

void print_path(int k_ind, int e) {
    std::vector <int> path;
    int t = e;
    path.push_back(t);
    while (from[t] != -1) {
        path.push_back(from[t]);
        t = from[t];
    }

    std::reverse(path.begin(), path.end());

    for (int i: path) {
        p[i][k_ind] = true;
        // std::cout << i << " ";
    }
    // std::cout << std::endl;
}

void find_path(int s, int e, int k_ind) {
    for (int i = 0; i < n; i++) dists[i] = -1;
    for (int i = 0; i < n; i++) from[i] = -1;

    dists[s] = 0;

    std::queue <int> q;
    q.push(s);

    while (!q.empty()) {
        int curr_elem = q.front(); q.pop();
        // std::cout << "right now at: " << curr_elem+1 << std::endl;
        
        for (int i: v[curr_elem]) {
            from[i] = curr_elem;
            dists[i] = dists[curr_elem] + 1;
            q.push(i);
            if (i == e) {
                // std::cout << "found it, from: " << from[e]+1 << std::endl;
                print_path(k_ind, e);
            }
            // std::cout << "set from[" << i+1 << "] to " << curr_elem+1 << std::endl;
        }
    }
}

int dp[MAX_N];

// int count_ways(int ind) {
//     if (dp[ind] != -1) return dp[ind];
//     dp[ind] = count_ways
// }

int main() {
    std::cin >> n;

    for (int i = 0; i < n; i++) dp[i] = -1;
    for (int i = 0; i < (n-1); i++) {
        int x, y;
        std::cin >> x >> y; x--; y--;
        v[x].push_back(y);
    }

    std::cin >> k;

    for (int i = 0; i < k; i++) {
        int s, e;
        std::cin >> s >> e; s--; e--;
        find_path(s, e, i);
    }

    int ans = 0;

    for (int i = 0; i < (1 << k); i++) {
        int curr_sum[100]; for (int j = 0; j < n; j++) curr_sum[j] = 0;
        for (int j = 0; j < n; j++) {
            if (i & (1 << j)) {
                for (int t = 0; t < n; t++) {
                    curr_sum[t] += p[t][j];
                }
            }
        }

        bool is_ok = true;
        for (int j = 0; j < n; j++) {
            if (curr_sum[j] == 0) {
                is_ok = false;
                break;
            }
        }

        if (is_ok) ans++;
    }

    std::cout << ans << std::endl;
    // std::cout << count_ways(0);
}