#include <iostream>
#include <vector>
#include <algorithm>

#define MAX_N 1000000

int a[MAX_N];
int b[MAX_N];
bool ans[MAX_N];
bool new_ans[MAX_N];
int n;

void log_vector(std::vector <int> &r) {
    for (int i = 0; i < r.size(); i++) std::cout << r[i] << " ";
    std::cout << std::endl;
}

void log_ans() {
    for (int i = 0; i < n; i++) {
        std::cout << ans[i];
    }
    std::cout << std::endl;
}

inline bool can_beat(int ind1, int ind2) {
    return a[ind1] >= a[ind2] || b[ind1] >= b[ind2]; 
}

void add_player(int ind) {
    //check if it can beat player that can beat the rest
    for (int i = 0; i < ind; i++) {
        if (ans[i] && can_beat(ind, i)) {
            ans[ind] = true;
            break;
        }
    }

    //check if any playes lose their ability
    for (int i = 0; i < ind; i++) {
        new_ans[i] = false;
        for (int j = 0; j <= ind; j++) {
            if (j == i) continue;
            if ((can_beat(i, j) && ans[j]) || (ind == 1 && can_beat(i, j))) {
                new_ans[i] = true; 
                break;
            }
        }
    }

    //update ans
    for (int i = 0; i < ind; i++) {
        ans[i] = new_ans[i];
    }

    // log_ans();
}

int main() {
    std::cin >> n;
    ans[0] = true;

    for (int i = 0; i < n; i++) {
        std::cin >> a[i] >> b[i];
        add_player(i);
    }
    
    for (int i = 0; i < n; i++) {
        std::cout << (ans[i] ? 'W' : 'L');
    }
}