#include<bits/stdc++.h>
#pragma GCC optimize ("O3")
#pragma GCC optimize ("unroll-loops")

using namespace std;

struct edge {
    int to, cost;
    edge(int to, int cost) {
        this->to = to;
        this->cost = cost;
    }
    edge() = default;
    const bool operator>(const edge& other) {
        return cost > other.cost;
    }
};

const bool operator>(const edge& a, const edge& b) {
    return a.cost > b.cost;
}

vector<edge> graph[5001];
bool visited[5001];
long long cost[5001];

int main() {
    int n, m;
    cin >> n >> m;

    for(int i = 0; i < m; i++) {
        edge s;
        int u;
        cin >> u >> s.to >> s.cost;

        graph[u].push_back(s);
    }

    for(int u = 0; u < n; u++) {
        priority_queue<edge, vector<edge>, greater<edge>> pq;

        pq.emplace(u, 0);

        fill(visited, visited+n, false);
        fill(cost, cost+n, ~(1ll << 63));

        //cost[u] = 0;

        while(!pq.empty()) {
            edge e = pq.top();
            pq.pop();
            visited[e.to] = true;

            for(edge next : graph[e.to]) {
                cost[next.to] = min(cost[next.to], (e.to == u ? 0 : cost[e.to]) + next.cost);
                if(next.cost < 0) return 0;
                if(next.cost > 2) continue;
                if(!visited[next.to]) pq.emplace(next.to, cost[next.to]);
            }
        }

        if(cost[u] <= 1) {
            //cout << u << ": " << 1;
            cout << 1;
            return 0;
        }
    }

    cout << 0;
    return 0;
}
/*
6 7
0 1 0
0 2 0
0 4 1
1 2 3
2 3 0
3 0 1
5 2 0

*/
