#include<bits/stdc++.h>
#pragma GCC optimize ("O3")
#pragma GCC optimize ("unroll-loops")

using namespace std;

struct range {
    int from, to;
    int added = 1;
    range(const int& from, const int& to) {
        int f = from;
        int t = to;
        if(f > t) swap(f, t);

        this->from = f;
        this->to = t;
    }
    range() = default;

    range operator+(const range& other) {
        range r = range(min(from, other.from), max(to, other.to));
        r.added = added + 1;
        return r;
    }
};

const bool operator>(const range& a, const range& b) {
    if(a.from == b.from) return a.to > b.to;
    return a.from > b.from;
}

const bool operator<(const range& a, const range& b) {

    if(a.from == b.from) return a.to < b.to;
    return a.from < b.from;
}

vector<range> ranges;
int n, k;
long long result = 0;

void add(int perm) {
    long long mult = 1;
    for(int i = 0; i < perm; i++) {
        mult <<= 1;
        mult %= 1000000007;
    }
    //cout << "adding " << mult << endl;
    result += mult;
    result %= 1000000007;
}

void dfs(range& cur_range) {
    //cout << "visiting " << cur_range.from << " - " << cur_range.to << " (" << cur_range.added << ")" << endl;
    if(cur_range.to == n) {
        add(ranges.size() - cur_range.added);
    }
    for(int i = 0; i < ranges.size(); i++) {
        if(ranges[i].from < cur_range.to) continue;
        if(ranges[i].from > cur_range.to) break;
        range new_range = cur_range + ranges[i];
        dfs(new_range);
    }
}

int main() {
    cin >> n;

    for(int i = 1; i < n; i++) {
        cin >> k >> k;
    }

    cin >> k;

    for(int i = 0; i < k; i++) {
        int a, b;
        cin >> a >> b;

        ranges.emplace_back(a, b);
    }

    sort(ranges.begin(), ranges.end());
    //for(int i = 0; i < ranges.size(); i++) cout << ranges[i].from << " " << ranges[i].to << endl;
    for(int i = 0; i < ranges.size(); i++) {
        range cur_range = ranges[i];
        if(cur_range.from > 1) break;

        dfs(cur_range);

    }



    cout << result;
    return 0;
}

/*
5
1 2
2 3
3 4
4 5
3
1 3
3 4
3 5


6
1 2
1 3
1 4
1 5
1 6
7
1 2
1 2
1 2
1 3
1 4
1 5
1 6
*/
