#include <bits/stdc++.h>
using namespace std;

#ifndef GIGO_DEBUG
#define cerr if(false)cerr
#endif // GIGO_DEBUG

typedef unsigned long long ull;

const int MAXN = 5007;
const int MAXK = 200007;
const ull MOD = 1000000007;

int n, k;
vector<int> G[MAXN];
pair<int, int> routeEnds[MAXK];
set<int> routes[MAXK];
vector<int> startingAt[MAXN];

void extract_routes(){
    /// subproblems 3, 4, 5
    for(int i = 0; i < k; i++){
        startingAt[ routeEnds[i].first ].push_back(i);
        for(int j = routeEnds[i].first; j <= routeEnds[i].second; j++){
            routes[i].insert(j);
        }
    }
}

ull pow2(ull pow){
    ull res = 1;
    ull mul = 1;
    while(pow > 0){
        if(pow%2 == 1){ res <<= mul; pow--; }
        else{ mul *= 2; pow>>=1; }
    }
    return res;
}

int main(){
    #ifndef GIGO_DEBUG
    ios_base::sync_with_stdio(false);
    cin.tie(nullptr);
    cout.tie(nullptr);
    #endif // GIGO_DEBUG

    cin >> n;
    for(int i = 0; i < n-1; i++){
        int u, v;
        cin >> u >> v;
        u--; v--;
        G[u].push_back(v);
    }
    cin >> k;
    for(int i = 0; i < k; i++){
        int s, e;
        cin >> s >> e;
        routeEnds[i] = {s-1, e-1};
    }
    extract_routes();
    priority_queue<int> ends;

    ull ways = 1;
    for(int i = 0; i < n; i++){
        if(startingAt[i].size() == 0){ continue; }
        ways *= (pow2(startingAt[i].size()) - 1) % MOD;
        ways %= MOD;
    }
    cout << ways << '\n';
    return 0;

//    contingWays[0] = (1<<startingAt[0].size())-1; /// continuing
//    endingWays[0] = 0;
//    /// TODO: add ends for 0
//    for(int i = 1; i < n; i++){
//        /// ending = kolko(ends[i])
//        /// conting = ends.size() * 2^startAt
//
//        ways[i] += endingWays[i-1]*((1<<startingAt[i].size())-1); /// begin new
//        ways[i] += contingWays[i-1] * (1<<startingAt[i].size());
//
//        ways = (1<<startingAt[i].size())-1 + ends.size()*(1 << startingAt[i].size());
//        for(int rt : startingAt[i]){
//            ends.push(routeEnds[rt].second);
//        }
//        cerr << "ways[" << i+1 << "] = " << ways << "\n";
//
//        while(!ends.empty() && ends.top() <= i){ ends.pop(); }
//    }
//
//    cout << ways << '\n';

    return 0;
}
/*
8
1 2 2 3 3 4 4 5 5 6 6 7 7 8
8
1 3
7 8
2 4
5 7
4 5
7 8
2 5
6 7
*/
/*
4
1 2 2 3 3 4
4
1 2
1 2
3 4
3 4
*/
