#include <iostream>
#include <vector>
#include <queue>
#include <climits>

using namespace std;

struct Graph
{
    int vert;
    vector<vector<int>> adj;
    vector<vector<int>> dist;

    Graph(int v)
    {
        this->vert = v;
        this->adj = vector<vector<int>>(v+1, vector<int>());
        this->dist = vector<vector<int>>(v+1, vector<int>(v+1, INT_MAX));
    }

    void add_edge(int a, int b, int c)
    {
        this->adj[a].push_back(b);
        this->dist[a][b] = c;
        this->dist[a][a] = 0;
        this->dist[b][b] = 0;
    }

    void traverse(int start)
    {
        vector<bool> visited(this->vert+1, false);

        queue<int> q;
        q.push(start);

        while(!q.empty())
        {
            int v = q.front();
            q.pop();
            visited[v] = true;

            for(auto cur : adj[v])
            {
                if(!visited[cur])
                {
                    q.push(cur);
                }
                dist[start][cur] = min(dist[start][cur], dist[start][v]+dist[v][cur]);
            }
        }

    }
};

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int n;
    int m;
    int a, b, c;

    cin >> n >> m;

    Graph g(n);

    for(int i = 0; i < m; ++i)
    {
        cin >> a >> b >> c;
        g.add_edge(a, b, c);
    }

    for(int i = 1; i <= n; ++i)
    {
        g.traverse(i);
        for(int j = 1; j <= n; ++j)
        {
            if(g.dist[j][j] < 0)
            {
                cout << 1;
                return 0;
            }
        }
    }

    cout << 0;

    return 0;
}