#include <iostream>
#include <vector>
#include <set>
#include <unordered_map>

using namespace std;

const int MAX = 1000000;

int n;
vector<int> a(MAX);
vector<int> b(MAX);

vector<bool> used(MAX, false);
unordered_map<int, bool> res;

bool can_win_fight(int f, int s)
{
    if(a[f] >= a[s] || b[f] >= b[s])
        return true;

    return false;
}

bool can_win(int f)
{
    if(res.find(f)!=res.end())
        return res[f];

    int ct = 0;
    for(int i = 0; i<n; ++i)
    {
        if(!used[i])
        {
            if(i == f) continue;

            // cout << f << " vs " << i << "\n";

            if(can_win_fight(f, i))
            {
                used[f] = true;
                if(can_win(i))
                {
                    res.emplace(i, true);
                    return true;
                }
                else
                {
                    res.emplace(i, false);
                }
            }
        }
        else
        {
            ct++;
        }
    }
    if(ct == n-1)
        return true;

    return false;
}

void solve()
{
    cin >> n;

    for(int i = 0; i < n; ++i)
    {
        cin >> a[i];
        cin >> b[i];
    }

    for(int i = 0; i < n; ++i)
    {
        cout << (can_win(i) ? 'W' : 'L');
        used = vector<bool>(n, false);
    }
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    solve();

    return 0;
}