#include <bits/stdc++.h>

using namespace std;

const int maxn = 5005;
const long long inf = (1LL << 62);

int n, m;
vector<pair<int, int>> g[maxn];
vector<pair<int, int>> r[maxn];

long long dist[maxn];

void BellmanFord()
{
    for (int i = 1; i <= 1; ++i)
    {
        for (int j = 1; j <= n; ++j)
        {
            dist[j] = inf;
        }

        dist[i] = 0;

        int cnt = 0;

        while (true)
        {
            ++cnt;
            bool relaxed = false;

            for (int node = 1; node <= n; ++node)
            {
                for (auto [to, w] : g[node])
                {
                    if (dist[to] > w + dist[node])
                    {
                        dist[to] = w + dist[node];
                        relaxed = true;
                    }
                }
            }

            if (!relaxed) break;
            if (cnt > n)
            {
                cout << 1 << endl;
                exit(0);
            }
        }
    }
}

bool visited[maxn];
vector<int> outOrder;

void dfs1(int node)
{
    visited[node] = true;

    for (auto [to, w] : g[node])
    {
        if (visited[to] == false)
        {
            dfs1(to);
        }
    }

    outOrder.push_back(node);
}

int whichComponent[maxn];
int compCnt = 0;

void dfs2(int node)
{
    whichComponent[node] = compCnt;
    visited[node] = true;

    for (auto [to, w] : r[node])
    {
        if (visited[to] == false)
        {
            dfs2(to);
        }
    }
}

void SCC()
{
    for (int i = 1; i <= n; ++i)
    {
        if (visited[i] == false)
        {
            dfs1(i);
        }
    }

    for (int i = 1; i <= n; ++i)
    {
        visited[i] = false;
    }

    for (int i = n - 1; i >= 0; --i)
    {
        int node = outOrder[i];

        if (visited[node] == false)
        {
            ++compCnt;
            dfs2(node);
        }
    }
}

int par[maxn];
vector<int> found;

int mat[maxn][maxn];

void dfsCycle(int start, int node)
{
    visited[node] = true;

    for (auto [to, w] : g[node])
    {
        if (visited[to] == false)
        {
            par[to] = node;
            dfsCycle(start, to);
        }
        else if (to == start)
        {
            found.push_back(node);
        }
    }
}

void Calc()
{
    for (int i = 1; i <= n; ++i)
    {
        for (int j = 1; j <= n; ++j)
        {
            par[j] = -1;
            visited[j] = false;
        }

        found.clear();
        dfsCycle(i, i);

        for (auto node : found)
        {
            long long sum = mat[node][i];
            while (node != i)
            {
                sum += mat[par[node]][node];
                node = par[node];
            }

            if (sum == 0)
            {
                cout << 1 << endl;
                exit(0);
            }
        }
    }
}

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n >> m;

    for (int i = 1; i <= m; ++i)
    {
        int x, y, w;
        cin >> x >> y >> w;
        ++x;
        ++y;

        g[x].push_back({y, w});
        r[y].push_back({x, w});
        mat[x][y] = w;
    }

    BellmanFord();
    SCC();

    Calc();

    cout << 0 << endl;

    return 0;
}
