#include <bits/stdc++.h>

using namespace std;

const int maxn = 5005;
const long long inf = (1LL << 62);

int n, m;
vector<pair<int, int>> g[maxn];
vector<pair<int, int>> r[maxn];

bool visited[maxn];
vector<int> outOrder;

void dfs1(int node)
{
    visited[node] = true;

    for (auto [to, w] : g[node])
    {
        if (visited[to] == false)
        {
            dfs1(to);
        }
    }

    outOrder.push_back(node);
}

int sz = 0;

void dfs2(int node)
{
    ++sz;
    visited[node] = true;

    for (auto [to, w] : r[node])
    {
        if (visited[to] == false)
        {
            dfs2(to);
        }
    }
}

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n >> m;

    for (int i = 1; i <= m; ++i)
    {
        int x, y, w;
        cin >> x >> y >> w;
        ++x;
        ++y;

        if (w > 0) continue;

        g[x].push_back({y, w});
        r[y].push_back({x, w});
    }

    for (int i = 1; i <= n; ++i)
    {
        if (visited[i] == false)
        {
            dfs1(i);
        }
    }

    for (int i = 1; i <= n; ++i)
    {
        visited[i] = false;
    }

    for (int i = n - 1; i >= 0; --i)
    {
        int node = outOrder[i];

        if (visited[node] == false)
        {
            sz = 0;
            dfs2(node);
            if (sz >= 2)
            {
                cout << 1 << endl;
                return 0;
            }
        }
    }

    cout << 0 << endl;

    return 0;
}
