#include <bits/stdc++.h>

using namespace std;

const int maxn = 5005;
const long long inf = (1LL << 62);

int n, m;
vector<pair<int, int>> g[maxn];

bool inQ[maxn];
int cnt[maxn];
int inDegree[maxn];

long long dist[maxn];

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n >> m;

    for (int i = 1; i <= m; ++i)
    {
        int x, y, w;
        cin >> x >> y >> w;
        ++x;
        ++y;

        g[x].push_back({y, w});
        ++inDegree[y];
    }

    for (int i = 1; i <= n; ++i)
    {
        for (int j = 1; j <= n; ++j)
        {
            dist[j] = inf;
        }

        dist[i] = 0;

        int cnt = 0;

        while (true)
        {
            ++cnt;
            bool relaxed = false;

            for (int node = 1; node <= n; ++node)
            {
                for (auto [to, w] : g[node])
                {
                    if (dist[to] > w + dist[node])
                    {
                        dist[to] = w + dist[node];
                        relaxed = true;
                    }
                }
            }

            if (!relaxed) break;
            if (cnt > n)
            {
                cout << 1 << endl;
                return 0;
            }
        }
    }

    cout << 0 << endl;

    return 0;
}
