#include <bits/stdc++.h>

using namespace std;

const int maxn = 5005;
const long long inf = (1LL << 62);

int n, m;
vector<pair<int, int>> g[maxn];

bool inQ[maxn];
int cnt[maxn];
int inDegree[maxn];

long long dist[maxn];

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n >> m;

    for (int i = 1; i <= m; ++i)
    {
        int x, y, w;
        cin >> x >> y >> w;
        ++x;
        ++y;

        g[x].push_back({y, w});
        ++inDegree[y];
    }

    for (int i = 1; i <= n; ++i)
    {
        dist[i] = inf;
        inQ[i] = false;
    }

    queue<int> q;

    for (int i = 1; i <= n; ++i)
    {
        if (inDegree[i] == 0)
        {
            inQ[i] = true;
            q.push(i);
            dist[i] = 0;
            cnt[i] = 0;
        }
    }

    while (!q.empty())
    {
        int node = q.front();
        q.pop();
        inQ[node] = false;

        ++cnt[node];

        if (cnt[node] > 2 * (n + m))
        {
            cout << 1 << endl;
            return 0;
        }

        for (auto [to, w] : g[node])
        {
            long long path = dist[node] + w;

            if (dist[to] > path)
            {
                q.push(to);
                inQ[to] = true;
                dist[to] = path;
            }
        }
    }

    cout << 0 << endl;

    return 0;
}
