#include <bits/stdc++.h>

using namespace std;

const int maxn = 1e6 + 5;

int n;

struct Fighter
{
    int a, b;
    int idx;

    friend bool operator < (const Fighter& lf, const Fighter& rf)
    {
        if (lf.a != rf.a) return lf.a < rf.a;
        return lf.b < rf.b;
    }
};

Fighter a[maxn];

char answer[maxn];

vector<int> g[maxn];
bool visited[maxn];
bool isSpecial[maxn];

bool solved = false;

void dfs(int node)
{
    visited[node] = true;
    if (isSpecial[node] == true)
    {
        solved = true;
    }

    for (auto to : g[node])
    {
        if (visited[to] == false)
        {
            dfs(to);
        }
    }
}

unordered_map<int, int> compressed;
int currCompr = 0;
vector<int> toCompress;

void compress()
{
    sort(toCompress.begin(), toCompress.end());

    for (int i = 0; i < toCompress.size(); ++i)
    {
        if (i == toCompress.size() - 1 || toCompress[i] != toCompress[i + 1])
        {
            compressed[toCompress[i]] = ++currCompr;
        }
    }
}

struct FenwickTree
{
    int tree[maxn];

    void update(int pos, int val)
    {
        for (; pos <= currCompr; pos += (pos & (-pos)))
        {
            tree[pos] = max(tree[pos], val);
        }
    }

    int query(int pos)
    {
        int res = 0;

        for (; pos >= 1; pos -= (pos & (-pos)))
        {
            res = max(res, tree[pos]);
        }

        return res;
    }
};

FenwickTree tree;

bool positioned[maxn];

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n;

    for (int i = 1; i <= n; ++i)
    {
        cin >> a[i].a >> a[i].b;
        a[i].idx = i;
        answer[i] = 'L';
        toCompress.push_back(a[i].b);
    }

    compress();

    sort(a + 1, a + n + 1);

    for (int i = 2; i <= n; ++i)
    {
        g[i].push_back(i - 1);
        if (a[i - 1].a == a[i].a) g[i - 1].push_back(i);
    }

    for (int i = 1; i <= n; ++i)
    {
        if (a[i].a == a[n].a)
        {
            isSpecial[i] = true;
        }
    }

    tree.update(compressed[a[n].b], n);

    for (int i = n - 1; i >= 1; --i)
    {
        int idx = tree.query(compressed[a[i].b]);
        if (idx != 0) g[i].push_back(idx);

        if (positioned[compressed[a[i].b]] == false)
        {
            tree.update(compressed[a[i].b], i);
            positioned[compressed[a[i].b]] = true;
        }
    }

    for (int i = 1; i <= n; ++i)
    {
        dfs(i);

        if (solved)
        {
            answer[a[i].idx] = 'W';
        }

        if (answer[a[i].idx] == 'W')
        {
            for (int j = i + 1; j <= n; ++j)
            {
                answer[a[j].idx] = 'W';
            }

            break;
        }
    }

    for (int i = 1; i <= n; ++i)
    {
        cout << answer[i];
    }

    cout << endl;

    return 0;
}

/*
5
1 7
2 8
3 9
4 6
5 9
*/
