#include <bits/stdc++.h>

using namespace std;

const int maxn = 1e6 + 5;

int n;

struct Fighter
{
    int a, b;
    int idx;
};

Fighter a[maxn];

char answer[maxn];

vector<int> g[maxn];
bool visited[maxn];
bool isSpecial[maxn];

bool solved = false;

void dfs(int node)
{
    visited[node] = true;
    if (isSpecial[node] == true)
    {
        solved = true;
    }

    for (auto to : g[node])
    {
        if (visited[to] == false)
        {
            dfs(to);
        }
    }
}

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n;

    for (int i = 1; i <= n; ++i)
    {
        cin >> a[i].a >> a[i].b;
        a[i].idx = i;
        answer[i] = 'L';
    }

    sort(a + 1, a + n + 1, [](Fighter& lf, Fighter& rf)
    {
        if (lf.a != rf.a) return lf.a < rf.a;
        return lf.b < rf.b;
    });

    for (int i = 2; i <= n; ++i)
    {
        g[i].push_back(i - 1);
        if (a[i - 1].a == a[i].a) g[i - 1].push_back(i);
    }

    for (int i = 1; i <= n; ++i)
    {
        if (a[i].a == a[n].a)
        {
            isSpecial[i] = true;
        }
    }

    set<pair<int, int>> currentB;
    set<int> inserted;
    currentB.insert({a[n].b, n});

    for (int i = n - 1; i >= 1; --i)
    {
        auto it = currentB.upper_bound({a[i].b, 0});

        if (it != currentB.begin())
        {
            --it;
            int idx = it->second;
            g[i].push_back(idx);
        }

        if (inserted.find(a[i].b) == inserted.end())
        {
            inserted.insert(a[i].b);
            currentB.insert({a[i].b, i});
        }
    }

    for (int i = 1; i <= n; ++i)
    {
        dfs(i);

        if (solved)
        {
            answer[a[i].idx] = 'W';
        }

        if (answer[a[i].idx] == 'W')
        {
            for (int j = i + 1; j <= n; ++j)
            {
                answer[a[j].idx] = 'W';
            }

            break;
        }
    }

    for (int i = 1; i <= n; ++i)
    {
        cout << answer[i];
    }

    cout << endl;

    return 0;
}

/*
5
1 7
2 8
3 9
4 6
5 9
*/
