#include <bits/stdc++.h>

using namespace std;

const int maxn = 3005;

int n;

struct Fighter
{
    int a, b;
    int idx;
};

Fighter a[maxn];

char answer[maxn];

vector<int> g[maxn];

bool dp[maxn], bl[maxn];

bool f(int node)
{
    if (a[node].a == a[n].a)
    {
        return true;
    }

    if (bl[node]) return dp[node];
    bl[node] = true;

    for (auto to : g[node])
    {
        dp[node] |= f(to);
    }

    return dp[node];
}

void fastIO()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);
}

int main()
{
    fastIO();

    cin >> n;

    for (int i = 1; i <= n; ++i)
    {
        cin >> a[i].a >> a[i].b;
        a[i].idx = i;
        answer[i] = 'L';
    }

    sort(a + 1, a + n + 1, [](Fighter& lf, Fighter& rf)
    {
        if (lf.a != rf.a) return lf.a < rf.a;
        return lf.b < rf.b;
    });

    for (int i = 2; i <= n; ++i)
    {
        g[i].push_back(i - 1);
        if (a[i - 1].a == a[i].a) g[i - 1].push_back(i);
    }

    for (int i = 1; i <= n; ++i)
    {
        for (int j = n; j >= i; --j)
        {
            if (a[i].b >= a[j].b)
            {
                g[i].push_back(j);
                break;
            }
        }
    }

    for (int i = 1; i <= n; ++i)
    {
        if (f(i)) answer[a[i].idx] = 'W';
    }

    for (int i = 1; i <= n; ++i)
    {
        cout << answer[i];
    }

    cout << endl;

    return 0;
}

/*
5
1 7
2 8
3 9
4 6
5 9
*/
