#include<bits/stdc++.h>
using namespace std;

vector<int> perm_vec(int start, int planets) {
    vector<int> vec{};
    for(int i=0; i<planets; i++) {
        if(i != start) {
            vec.push_back(i);
        }
    }
    return vec;
}

bool has_path(int a, int b, unordered_map<int, unordered_map<int, int>>& graph) {
    if(graph[a].contains(b)) return true;
    else return false;
}

bool has_suitable_path(int start, vector<int> vec, unordered_map<int, unordered_map<int, int>>& graph) {
    for(int i=1; i<vec.size(); i++) {

        int price = 0;
        bool path = true;

        vector<int> vec_c = vec;
        vec_c.resize(i);

        //cout << "\n---Trying sequence: " << start << " -> ";
        //for (auto el : vec_c) {
        //    cout << el << " -> ";
        //}
        //cout << start << " --- ";

        int prev = start;
        for(auto el : vec_c) {
            if(!has_path(prev, el, graph)) {
                path = false;
                break;
            }
            price += graph[prev][el];
            prev = el;
        }

        //out << "path, price(?): " << path << " ";

        if(!path) continue;

        if(has_path(prev, start, graph)) {
            price += graph[prev][start];
            //cout << price;
            if(price <= 0) return true;
        }
    }

    return false;
}

int main()
{
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int planeti, poleti;
    cin >> planeti >> poleti;

    unordered_map<int, unordered_map<int, int>> graph{};

    for(int i=0; i<poleti; i++) {
        int a,b,price;
        cin >> a >> b >> price;

        graph[a][b] = price;
    }

    for(int i=0; i < planeti; i++) {
        auto permer = perm_vec(i, planeti);
        auto original_permer = permer;
        do {
            if (has_suitable_path(i, permer, graph)) {
                cout << 1;
                return 0;
            }

            next_permutation(permer.begin(), permer.end());
        } while (original_permer != permer);
    }

    cout << 0;

    return 0;
}
