#include <bits/stdc++.h>

using namespace std;

void visit_nodes(int player, vector<bool>& visited, unordered_map<int, vector<int>>& can_kill) {
    visited[player] = true;
    //cout << "visiting " << player << "\n";
    for(int& num : can_kill[player]) {
        if(!visited[num]) {
            visit_nodes(num, visited, can_kill);
        }
    }
}

bool can_win(int player, int n, unordered_map<int, vector<int>>& can_kill, vector<bool>& visited) {
    visited.clear();
    visited.resize(n);

    visit_nodes(player, visited, can_kill);

    bool win = true;
    for(int i=0; i<n; i++) {
        if(!visited[i]) {
            win = false;
            break;
        }
        //cout<<"$" << visited[i] << "$";
    }

    //cout << win << " win ----\n";

    return win;
}

bool can_kill_winner(int player, unordered_map<int, vector<int>>& can_kill, vector<bool>& winners) {
    for(auto& killed : can_kill[player]) {
        if(winners[killed]) return true;
    }

    return false;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int n;
    cin >> n;

    vector<pair<int, int>> fighters{};
    unordered_map<int, vector<int>> can_kill{};

    int a,b;
    bool special_mode = true;

    for(int i=0; i<n; i++) {
        cin >> a >> b;
        fighters.push_back(make_pair(a, b));
        vector<int> vec{};
        can_kill[i] = vec;
        if(a != b) special_mode = false;
    }

    if (special_mode) {
        int maxx = 0;

        for(int i=0;i<n;i++) {
            if(fighters[i].first > maxx) {
                maxx = fighters[i].first;
            }
        }

        for(int i=0;i<n;i++) {
            if(fighters[i].first == maxx) {
                cout << "W";
            }
            else cout << "L";
        }

        return 0;
    }

    for(int i=0; i<n-1; i++) {
        for (int j=i+1;j<n;j++) {
            if(fighters[i].first >= fighters[j].first || fighters[i].second >= fighters[j].second) can_kill[i].push_back(j);
            if(fighters[i].first <= fighters[j].first || fighters[i].second <= fighters[j].second) can_kill[j].push_back(i);
        }
    }

    //for(int i=0;i<n;i++) {
    //    cout << "Player " << i << " can win? " << can_win(i, can_kill);
    //    cout << "\nPlayer " << i << " can kill ";
    //    for(int& num : can_kill[i]) {
    //        cout << num << " ";
    //    }
    //    cout << "\n";
    //}

    vector<bool> winners{};
    winners.resize(n);

    vector<bool> visited{};

    for(int i=0;i<n;i++) {
        if(can_kill_winner(i, can_kill, winners)) {
            cout << "W";
            winners[i] = true;
        }
        else if(can_win(i, n, can_kill, visited)){
            cout << "W";
            winners[i] = true;
        }
        else cout << "L";
    }


}
