#include <bits/stdc++.h>

using namespace std;

void visit_nodes(int player, vector<bool>& visited, map<int, vector<int>>& can_kill) {
    visited[player] = true;
    //cout << "visiting " << player << "\n";
    for(int& num : can_kill[player]) {
        if(!visited[num]) {
            visit_nodes(num, visited, can_kill);
        }
    }
}

bool can_win(int player, map<int, vector<int>>& can_kill) {
    vector<bool> visited{};
    visited.resize(can_kill.size());
    //cout << "&&" << visited.size() << "&&";

    //cout << "Can he win??? " << player << "\n";

    visit_nodes(player, visited, can_kill);

    bool win = true;
    for(int i=0; i<can_kill.size(); i++) {
        if(!visited[i]) {
            win = false;
            break;
        }
        //cout<<"$" << visited[i] << "$";
    }

    //cout << win << " win ----\n";

    return win;
}

int main() {
    ios_base::sync_with_stdio(false);
    cin.tie(0);

    int n;
    cin >> n;

    vector<pair<int, int>> fighters{};
    map<int, vector<int>> can_kill{};

    int a,b;

    for(int i=0; i<n; i++) {
        cin >> a >> b;
        fighters.push_back(make_pair(a, b));
        vector<int> vec{};
        can_kill[i] = vec;
    }

    for(int i=0; i<n-1; i++) {
        for (int j=i+1;j<n;j++) {
            if(fighters[i].first >= fighters[j].first || fighters[i].second >= fighters[j].second) can_kill[i].push_back(j);
            if(fighters[i].first <= fighters[j].first || fighters[i].second <= fighters[j].second) can_kill[j].push_back(i);
        }
    }

    //for(int i=0;i<n;i++) {
    //    cout << "Player " << i << " can win? " << can_win(i, can_kill);
    //    cout << "\nPlayer " << i << " can kill ";
    //    for(int& num : can_kill[i]) {
    //        cout << num << " ";
    //    }
    //    cout << "\n";
    //}

    for(int i=0;i<n;i++) {
        if(can_win(i, can_kill)) cout << "W";
        else cout << "L";
    }


}
