#include "testlib.h"
#include<iostream>
#include<string>
#include<vector>
#define MAXN 5000
#define MAXK 200000
using namespace std;
vector <int> a[MAXN];
bool used[MAXN];
int in[MAXN],out[MAXN],h[MAXN],time1=0;
int dfs (int vr) {
    if (used[vr]==true) return 0;
    used[vr]=true;
    int cnt=1;
    in[vr]=time1++;
    for (auto to : a[vr]) {
        cnt+=dfs(to);
        h[vr]=max(h[vr],h[to]+1);
    }
    out[vr]=time1-1;
    return cnt;
}
int main (int argc, char* argv[]) {
    ensuref(argc>1,"The test validator needs arguments!");
    FILE* fin;
    fin=fopen(argv[1],"r");
    ensuref(fin!=NULL,"Wrong test name!");
    fclose(fin);
    freopen(argv[1],"r",stdin);
    registerValidation(argc,argv);

    int n=inf.readInt(1,MAXN,"N"); inf.readEoln();
    bool flag=true;
    for (int i=0; i<n-1; i++) {
        int x=inf.readInt(1,n,"u_"+to_string(i)); inf.readSpace();
        int y=inf.readInt(1,n,"v_"+to_string(i)); inf.readEoln();
        x--; y--;
        a[x].push_back(y);
        if ((x!=i)&&(y!=i+1)) flag=false;
    }
    ensuref(dfs(0)==n,"Not rooted tree at vertex 1!");
    int k=inf.readInt(1,MAXK,"K"); inf.readEoln();
    for (int i=0; i<k; i++) {
        int x=inf.readInt(1,n,"s_"+to_string(i)); inf.readSpace();
        int y=inf.readInt(1,n,"e_"+to_string(i)); inf.readEoln();
        x--; y--;
        ensuref((in[x]<=in[y])&&(in[y]<=out[x]),("Path from "+to_string(x+1)+" to "+to_string(y+1)+" is not from vertex to descendant!").c_str());
    }
    inf.readEof();

    cout << n << " " << k << " " << flag << endl ;
    HANDLE handle=GetStdHandle(STD_OUTPUT_HANDLE);
    SetConsoleTextAttribute(handle,10);
    if ((n<=10)&&(k<=18)) cout << "First subtask!\n";
    else if ((n<=50)&&(k<=22)) cout << "Second subtask!\n";
    else if ((n<=700)&&(k<=700)&&(h[0]==n-1)&&(flag==true)) cout << "Third subtask!\n";
    else if ((n<=3000)&&(k<=3000)&&(h[0]==n-1)&&(flag==true)) cout << "Fourth subtask!\n";
    else if ((n<=3000)&&(k<=MAXK)&&(h[0]==n-1)&&(flag==true)) cout << "Fifth subtask!\n";
    else if ((n<=MAXN)&&(k<=MAXK)&&(a[0].size()==n-1)) cout << "Sixth subtask!\n";
    else if ((n<=700)&&(k<=700)) cout << "Seventh subtask!\n";
    else if ((n<=MAXN)&&(k<=MAXK)) cout << "Eighth subtask!\n";
    else {
        SetConsoleTextAttribute(handle,12);
        cout << "? subtask!\n";
    }
    SetConsoleTextAttribute(handle,7);
    return 0;
}
