/* test generator uses testlib.h: https://github.com/MikeMirzayanov/testlib/blob/master/testlib.h
   arguments:
    - first - name of the test that will be generated
    - second - value of n
    - third - value of k
    - fourth - constant for controlling the tree
    - fifth - type of tree
        = 0 - normal tree
        = 1 - path tree
        = 2 - star tree
        = 3 - broom tree
    - sixth - constant for controlling the initial paths
    - seventh - constant for controlling the other paths
    - eighth - flag for answer 0 */
#include "testlib.h"
#include<iostream>
#include<ext/pb_ds/assoc_container.hpp>
#include<ext/pb_ds/tree_policy.hpp>
#include<unordered_set>
#include<vector>
#include "test_generator.h"
#define MAXN 5000
using namespace std;
using namespace __gnu_pbds;
template <typename T>
using ordered_set = tree <T, null_type, less <T>, rb_tree_tag, tree_order_statistics_node_update>;

vector <int> a[MAXN];
int deps[MAXN];
bool banned[MAXN];
vector <int> prv[MAXN];
vector <int> path;
void dfs (int vr, int dep) {
    deps[vr]=dep;
    vector <int> tmp;
    path.push_back(vr);
    if (banned[vr]==true) {
        tmp=path;
        path.clear();
    }
    prv[vr]=path;
    for (auto to : a[vr]) {
        dfs(to,dep+1);
    }
    if (banned[vr]==true) path=tmp;
    path.pop_back();
}

bool used[MAXN];
vector <pair <int, int>> paths;
int main (int argc, char** argv) {
    ensuref(argc>1,"The test generator needs arguments!");
    registerGen(argc,argv,1);
    check_tests(argc,argv);
    ensuref(argc>=6,"The test generator needs more arguments!");

    ofstream fout(argv[1]);
    int n=atoll(argv[2]),k=atoll(argv[3]);
    int t=atoll(argv[4]),type=atoll(argv[5]);
    int t2=atoll(argv[6]),t3=atoll(argv[7]);
    bool zero=atoll(argv[8]);

    vector <int> perm(n);
    for (int i=0; i<n; i++) {
        perm[i]=i;
    }
    if (type!=1) shuffle(perm.begin()+1,perm.end());
    for (int i=1; i<n; i++) {
        if (type==0) a[perm[rnd.wnext(i,t)]].push_back(perm[i]);
        else if (type==1) a[perm[i-1]].push_back(perm[i]);
        else if (type==2) a[0].push_back(perm[i]);
        else {
            if (i<n/2) a[perm[rnd.wnext(i,t)]].push_back(perm[i]);
            else a[perm[rnd.wnext(n/2-1,i-1,-(min(t*t,n)))]].push_back(perm[i]);
        }
    }
    if (zero==true) {
        int cnt=1;
        banned[perm[rnd.next(n)]]=true;
        for (;;) {
            if (rnd.next(2)==0) break;
            banned[perm[rnd.next(n)]]=true;
            cnt++;
        }
        cout << cnt << " ";
    }
    dfs(0,0);

    ordered_set <pair <int, int>> vers;
    for (int i=0; i<n; i++) {
        if (banned[i]==false) vers.insert({deps[i], i});
    }
    for (;;) {
        if (vers.empty()==true) break;
        int ind=(t2<0?rnd.wnext(vers.size(),-t2):rnd.next(vers.size()));
        int end=vers.find_by_order(ind)->second;
        int limit=0;
        for (int i=prv[end].size()-2; i>=0; i--) {
            if (used[prv[end][i]]==true) {
                limit=i+1;
                break;
            }
        }
        int from=rnd.wnext(limit,(int)prv[end].size()-1,t2);
        for (int i=from; i<(int)prv[end].size(); i++) {
            int curr=prv[end][i];
            used[curr]=true;
            vers.erase({deps[curr], curr});
        }
        paths.push_back({prv[end][from], end});
    }
    int maxdep=0;
    for (int i=0; i<n; i++) {
        maxdep=max(maxdep,deps[i]);
    }
    cout << maxdep << " " << paths.size() << endl ;

    vers.clear();
    for (int i=0; i<n; i++) {
        if (banned[i]==false) vers.insert({deps[i], i});
    }
    for (;;) {
        if ((int)paths.size()==k) break;
        int end=vers.find_by_order(t3<0?rnd.wnext(vers.size(),-t3):rnd.next(vers.size()))->second;
        int st=prv[end][rnd.wnext(prv[end].size(),t3)];
        paths.push_back({st, end});
    }

    fout << n << endl ;
    vector <pair <int, int>> edges;
    for (int i=0; i<n; i++) {
        for (auto to : a[i]) {
            edges.push_back({i, to});
        }
    }
    if (type!=1) shuffle(edges.begin(),edges.end());
    for (auto [u, v] : edges) {
        fout << u+1 << " " << v+1 << endl ;
    }
    fout << k << endl ;
    for (auto [st, fin] : paths) {
        fout << st+1 << " " << fin+1 << endl ;
    }
    fout.close();

    cout << "test successfully generated!!!" << endl ;
    validate_test(argc,argv);
    return 0;
}
