/* the core program has three arguments:
   - first - state of checking with three possible values:
              = 0 - checks the solution file according the answer file
              = x>0 - generates solution file with name from the third argument using the x-th solution
   - second - name of the input file
   - third - name of the file to be checked or generated
   - fourth - name of the correct output file (optional - only for option 0) */
#include<iostream>
#include<iomanip>
#include<string>
#include<vector>
#include<math.h>
#include "checker_tgen.h"
using namespace std;


int main (int argc, char** argv) {
    ifstream inp,out,ans;
    vector <string> solutions={
        "transport_100p",
        "transport_54p_subtask7",
        "transport_11p_subtask6",
        "transport_36p_subtask5",
        "transport_23p_subtask4",
        "transport_11p_subtask3",
        "transport_13p",
        "transport_7p"
    };
    check_arguments(argc,argv,inp,out,ans,solutions,"");
    inp.close();
    for (int i=1; ; i++) {
        int ans_out,ans_sol;
        if (!(ans >> ans_sol)) break;
        if (!(out >> ans_out)) {
            cout << "Missing output! " << i << endl ;
            exit(0);
        }
        if (ans_out!=ans_sol) {
            cout << "Wrong answer! " << ans_out << " " << ans_sol << endl ;
            exit(0);
        }
    }
    char tmp;
    if (out >> tmp) cout << "Extra output!\n";
    cout << "OK!";
    cout << endl ;
    return 0;
}
