#include <bits/stdc++.h>

typedef long long ll;

const ll MAX_N = 5e3 + 10;
ll n, m;
std::vector<ll> g[MAX_N];
std::vector<ll> pred[MAX_N];
ll dep[MAX_N];
ll dp[MAX_N][MAX_N];
ll up[MAX_N][MAX_N];
const ll mod = 1e9 + 7;

ll fpow(const ll x, const ll p) {
    if (p == 0) {
        return 1;
    }
    ll ans = fpow(x, p / 2);
    ans = ans * ans % mod;
    if (p & 1) {
        return (ans * x) % mod;
    } else {
        return ans;
    }
}

void dfs(const ll x, const ll d) {
    dep[x] = d;
    for (const auto it : pred[x]) {
        up[x][dep[it]] ++;
    }

    for (const auto it : g[x]) {
        dfs(it, d + 1);
    }

    dp[x][d + 1] = 1;
    ll pow2 = 1;
    for (ll upd = d; upd >= 0; upd --) {
        ll nowp2 = fpow(2, up[x][upd]);
        dp[x][upd] = pow2 * (nowp2 + mod - 1) % mod;
        pow2 = (pow2 * nowp2) % mod;
    }

    std::vector<ll> sums(g[x].size(), 0);
    ll prod = 0;
    ll old = 0;
    for (ll upd = d + 1; upd >= 0; upd --) {
        prod = (prod + dp[x][upd]) % mod;
        ll val = prod;
        for (ll i = 0; i < g[x].size(); i ++) {
            sums[i] = (sums[i] + dp[g[x][i]][upd]) % mod;
            val = (val * sums[i]) % mod;
        }
        dp[x][upd] = val;
        if (upd != d + 1) {
            dp[x][upd] = (dp[x][upd] - old + mod) % mod;
        }
        old = val;
    }
}

signed main() {
    std::ios_base::sync_with_stdio(false);
    std::cin.tie(NULL);

    std::cin >> n;
    for (ll i = 0; i < n - 1; i ++) {
        ll a, b;
        std::cin >> a >> b;
        g[a].push_back(b);
    }

    std::cin >> m;
    for (ll i = 0; i < m; i ++) {
        ll a, b;
        std::cin >> a >> b;
        pred[b].push_back(a);
    }
    dfs(1, 0);

    std::cout << dp[1][0] << std::endl;

    return 0;
}
