#include <iostream>
#include <stdio.h>
#include <vector>
#include <string.h>
using namespace std;
typedef long long llong;

const llong MOD = 1000000007LL;
const int MAXN = 5111;

int n, k;
vector<int> kids[MAXN];

int depth[MAXN];
int maxd = 0;

llong ways[MAXN][MAXN];

void getDepths(int ver, int d)
{
    maxd = max(maxd, d + 1);
    depth[ver] = d;
    for (auto x : kids[ver])
    {
        getDepths(x, d + 1);
    }
}

void mergeWays(llong* waysA, llong* waysB, llong* ans)
{
    llong curWaysA = 0;
    llong curWaysB = 0;
    int waysAidx = n;
    int waysBidx = n;

    for (int i = maxd; i >= 0; i--)
    {
        ans[i] = (waysA[i] * curWaysB + waysB[i] * curWaysA + waysA[i] * waysB[i]) % MOD;
        curWaysA = (curWaysA + waysA[i]);
        if (curWaysA >= MOD)
            curWaysA -= MOD;
        curWaysB = (curWaysB + waysB[i]);
        if (curWaysB >= MOD)
            curWaysB -= MOD;
    }
}

llong temp[MAXN];
void solve(int ver)
{
    for (auto x : kids[ver])
    {
        solve(x);

        memset(temp, 0, sizeof(temp));
        mergeWays(&ways[ver][0], &ways[x][0], &temp[0]);
        for (int j = 0; j <= maxd; j++)
        {
            ways[ver][j] = temp[j];
        }
    }

    for (int i = depth[ver] + 1; i <= maxd; i++)
    {
        ways[ver][i] = 0;
    }
}

llong pow2[200111];

int main()
{
    pow2[0] = 1LL;
    for (int i = 1; i <= 200000; i++)
    {
        pow2[i] = (pow2[i - 1] * 2LL) % MOD;
    }

    scanf("%d", &n);

    for (int i = 0; i < n - 1; i++)
    {
        int a, b;

        scanf("%d %d", &a, &b);

        kids[a].push_back(b);
    }

    getDepths(1, 0);

    scanf("%d", &k);

    for (int i = 0; i < k; i++)
    {
        int a, b;

        scanf("%d %d", &a, &b);

        ways[b][ depth[a] ]++;
    }

    for (int i = 1; i <= n; i++)
    {
        ways[i][maxd] = 1;
        llong waysSoFar = 1LL;
        for (int j = maxd - 1; j >= 0; j--)
        {
            ways[i][j] = (pow2[ ways[i][j] ] - 1LL) * waysSoFar;
            ways[i][j] %= MOD;

            waysSoFar += ways[i][j];
            if (waysSoFar >= MOD)
                waysSoFar -= MOD;
        }
    }

    solve(1);

    printf("%lld\n", ways[1][0]);

    return 0;
}
