#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXN = 1e6 + 10;

int n;
int a[MAXN];
int b[MAXN];
int perm[MAXN];
int prefMIN[MAXN];
int suffMAX[MAXN];

void solve()
{
    std::iota(perm + 1, perm + 1 + n, 1);
    std::sort(perm + 1, perm + 1 + n, [&](int x, int y)
    {
        return a[x] > a[y];
    });

    prefMIN[1] = b[perm[1]];
    for (int i = 2 ; i <= n ; ++i)
    {
        prefMIN[i] = std::min(prefMIN[i - 1], b[perm[i]]);
    }
    
    suffMAX[n] = b[perm[n]];
    for (int i = n - 1 ; i > 0 ; --i)
    {
        suffMAX[i] = std::max(suffMAX[i + 1], b[perm[i]]);
    }
    
    std::string ans(n, 'L');
    for (int i = 1 ; i <= n ; ++i)
    {
        ans[perm[i] - 1] = 'W';
        if (i + 1 <= n && a[perm[i + 1]] != a[perm[i]] && prefMIN[i] > suffMAX[i + 1])
        {
            break;
        }
    }

    std::cout << ans << '\n';
}

void input()
{
    std::cin >> n;
    assert(1 <= n && n <= 1000000);
    for (int i = 1 ; i <= n ; ++i)
    {
        std::cin >> a[i] >> b[i];
        assert(0 <= a[i] && a[i] <= 1e9);
        assert(0 <= b[i] && b[i] <= 1e9);
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    input();
    solve();

    return 0;
}