#include <iostream>
#include <stdio.h>
#include <algorithm>
#include <vector>
using namespace std;

vector<pair<int, int>> Asorted, Bsorted;

int getMinA()
{
    int aPower = -1;
    int bPower = -1;
    int nextAidx = 0;
    int nextBidx = 0;

    for (int i = 0; i < Asorted.size(); i++)
    {
        aPower = max(aPower, Asorted[i].first);
        bPower = max(bPower, Asorted[i].second);

        bool change = true;
        while(change)
        {
            change = false;
            while(nextAidx < Asorted.size() && Asorted[nextAidx].first <= aPower)
            {
                change = true;
                bPower = max(bPower, Asorted[nextAidx].second);
                nextAidx++;
            }

            while(nextBidx < Bsorted.size() && Bsorted[nextBidx].second <= bPower)
            {
                change = true;
                aPower = max(aPower, Bsorted[nextBidx].first);
                nextBidx++;
            }
        }

        if (nextAidx >= Asorted.size() || nextBidx >= Bsorted.size())
            return Asorted[i].first;
    }

    return Asorted.back().first;
}

int n;
vector<pair<int, int>> items;

bool SB(const pair<int, int>& A, const pair<int, int>& B)
{
    return make_pair(A.second, A.first) < make_pair(B.second, B.first);
}

int main()
{
    scanf("%d", &n);

    for (int i = 0; i < n; i++)
    {
        int a, b;

        scanf("%d %d", &a, &b);
        items.push_back({a, b});
    }

    Asorted = items;
    sort(Asorted.begin(), Asorted.end());
    Bsorted = items;
    sort(Bsorted.begin(), Bsorted.end(), SB);

    int minAwin = getMinA();

    for (int i = 0; i < n; i++)
    {
        swap(items[i].first, items[i].second);
    }

    Asorted = items;
    sort(Asorted.begin(), Asorted.end());
    Bsorted = items;
    sort(Bsorted.begin(), Bsorted.end(), SB);

    int minBwin = getMinA();

    for (int i = 0; i < n; i++)
    {
        swap(items[i].first, items[i].second);
        if (items[i].first >= minAwin || items[i].second >= minBwin)
            printf("W");
        else
            printf("L");
    }
    printf("\n");

    return 0;
}
