// sub4_scc_with_vectors.cpp
// Build explicit graph using vector<vector<int>> g and gr, then Kosaraju, condense, indegree check.
// Compile: g++ -O2 -std=c++17 sub4_scc_with_vectors.cpp -o sol

#include <bits/stdc++.h>
using namespace std;

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int N;
    if (!(cin >> N)) return 0;
    vector<int> A(N), B(N);
    for (int i = 0; i < N; ++i) cin >> A[i] >> B[i];

    auto edge = [&](int u, int v) -> bool {
        return (A[u] >= A[v]) || (B[u] >= B[v]);
    };

    // Build explicit adjacency lists
    vector<vector<int>> g(N), gr(N);
    for (int u = 0; u < N; ++u) {
        g[u].reserve(N / 8 + 1); // heuristic reserve
        for (int v = 0; v < N; ++v) {
            if (u == v) continue;
            if (edge(u, v)) {
                g[u].push_back(v);
                gr[v].push_back(u);
            }
        }
    }

    // Kosaraju first pass: compute order
    vector<char> used(N, 0);
    vector<int> order;
    order.reserve(N);
    vector<int> st_node;
    vector<int> st_it;
    st_node.reserve(N);
    st_it.reserve(N);

    for (int s = 0; s < N; ++s) {
        if (used[s]) continue;
        st_node.clear();
        st_it.clear();
        st_node.push_back(s);
        st_it.push_back(0);
        while (!st_node.empty()) {
            int v = st_node.back();
            int &it = st_it.back();
            if (!used[v]) used[v] = 1;
            if (it < (int)g[v].size()) {
                int to = g[v][it++];
                if (!used[to]) {
                    st_node.push_back(to);
                    st_it.push_back(0);
                }
            } else {
                order.push_back(v);
                st_node.pop_back();
                st_it.pop_back();
            }
        }
    }

    // Kosaraju second pass: assign components using gr
    vector<int> comp(N, -1);
    int C = 0;
    vector<int> stack2;
    stack2.reserve(N);
    for (int i = (int)order.size() - 1; i >= 0; --i) {
        int v = order[i];
        if (comp[v] != -1) continue;
        stack2.clear();
        stack2.push_back(v);
        comp[v] = C;
        while (!stack2.empty()) {
            int x = stack2.back(); stack2.pop_back();
            for (int to : gr[x]) {
                if (comp[to] == -1) {
                    comp[to] = C;
                    stack2.push_back(to);
                }
            }
        }
        ++C;
    }

    // Build condensed DAG indegrees by scanning g and deduplicating with last_seen
    vector<int> indeg(C, 0);
    vector<int> last_seen(C, -1);
    for (int u = 0; u < N; ++u) {
        int cu = comp[u];
        for (int v : g[u]) {
            int cv = comp[v];
            if (cu == cv) continue;
            if (last_seen[cv] != cu) {
                last_seen[cv] = cu;
                ++indeg[cv];
            }
        }
    }

    // Count components with indegree zero
    int zero_cnt = 0;
    int zero_comp = -1;
    for (int c = 0; c < C; ++c) {
        if (indeg[c] == 0) {
            ++zero_cnt;
            zero_comp = c;
            if (zero_cnt > 1) break;
        }
    }

    string ans(N, 'L');
    if (zero_cnt == 1) {
        for (int i = 0; i < N; ++i) if (comp[i] == zero_comp) ans[i] = 'W';
    }

    cout << ans << '\n';
    return 0;
}
