#include<iostream>
#include<vector>
#include<algorithm>
#include<cassert>
using namespace std;

const int MAXN = 1000000;

int parent[MAXN+2];
int height[MAXN+2];

int root(int u) {
    if (u == parent[u]) return u;
    return parent[u] = root(parent[u]);
}

void connect(int u, int v) {
    int rootU = root(u);
    int rootV = root(v);
    parent[rootV] = rootU;
    height[rootU] = max(height[rootU], height[rootV]);
}

int main() {
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    int n; cin >> n;
    assert(1 <= n && n <= 200000);

    vector<pair<int, int>> v(n);
    for (int i = 1; i <= n; i++) {
        int x; cin >> x;
        assert(1 <= x && x <= 1e9);
        v[i-1] = {x, i};
    }
    sort(v.begin(), v.end());

    for (int i = 0; i <= n+1; i++) parent[i] = i;

    int start = 0;
    for (int i = 0; i < n; i++) {
        if (i == n-1 || v[i].first != v[i+1].first) {
            for (int j = start; j <= i; j++) {
                int idx = v[j].second;
                if (j > start && v[j-1].second+1 == idx) {
                    height[idx] = height[root(idx+1)]+1;
                } else {
                    height[idx] = max(height[root(idx-1)], height[root(idx+1)])+1;
                }
            }

            for (int j = start; j <= i; j++) {
                int idx = v[j].second;
                if (height[root(idx-1)] != 0) connect(idx-1, idx);
                if (height[root(idx+1)] != 0) connect(idx+1, idx);
            }

            start = i+1;
        }
    }

    cout << height[root(1)] << endl;

    return 0;
}
