#include<iostream>
#include<random>
#include<fstream>
#include<vector>
#include<algorithm>
using namespace std;
random_device rd;
mt19937 mt(rd());
void gen_test(int n, int mval, ofstream& output, int mode)
{
    uniform_int_distribution<> dist(1,mval);
    uniform_int_distribution<> flip(1,50);
    int st=dist(mt);
    uniform_int_distribution<> dist2(1,max(st-1,1));
    int en=dist2(mt);
    if(mval==2)//special case for (1-2) subtask
    {
        int res=flip(mt);
        if(res<=3){st=1;en=1;}
        else if(res<=12){st=1;en=2;}
        else if(res<=47){st=2;en=1;}
        else {st=2;en=2;}
    }
    if(mode==6)//full-random
    {
        output<<st;
        for(int i=2;i<n;i++)
        {
            int num=dist(mt);
            output<<" "<<num;
        }
        output<<" "<<en;
        return;
    }
    if(mode==5)//equal-start-end
    {
        output<<st;//same as full-random, but en=st
        for(int i=2;i<n;i++)
        {
            int num=dist(mt);
            output<<" "<<num;
        }
        output<<" "<<st;
        return;
    }
    if(mode==4)//heaven-hell
    {
        const int delta=15;//can adjust constant
        uniform_int_distribution<> heaven((3*mval)/4,mval-delta);//heaven base
        int upperlayer=heaven(mt);
        uniform_int_distribution<> half_range(n/4,(3*n)/4);//midpoint range
        int mid=half_range(mt);

        if(mval==2)
        {
            output<<"2";
            for(int i=2;i<=mid;i++)output<<" 2";
            for(int i=mid+1;i<=n;i++)output<<" 1";
            return;
        }

        uniform_int_distribution<> diff(upperlayer-delta,upperlayer+delta);//allowed deviation
        output<<diff(mt);
        for(int i=2;i<mid;i++)
        {
            output<<" "<<diff(mt);
        }
        uniform_int_distribution<> hell(delta+1,mval/4);//hell base
        int lowerlayer=hell(mt);
        while(lowerlayer>=upperlayer-delta){lowerlayer=hell(mt);}
        uniform_int_distribution<> new_diff(lowerlayer-delta,lowerlayer+delta);//allowed deviation
        for(int i=mid;i<=n;i++)
        {
            output<<" "<<new_diff(mt);
        }
        return;
    }
    if(mode==3)//valley-mountain
    {
        output<<st;
        bool fl=0;
        int prev=st;
        for(int i=2;i<=n;i++)
        {
            uniform_int_distribution<> up(prev,mval);
            uniform_int_distribution<> down(1,prev);
            int curr;
            if(fl)curr=up(mt);
            else curr=down(mt);
            output<<" "<<curr;
            prev=curr;
            fl=!fl;
        }
        return;
    }
    if(mode==2)//half-descends
    {
        uniform_int_distribution<> half_range(n/4,(3*n)/4);//midpoint range
        uniform_int_distribution<> range(mval/2,mval);//val range
        int mid=half_range(mt);
        vector<int> order={};
        for(int i=1;i<=mid;i++)
        {
            order.push_back(range(mt));
        }
        sort(order.begin(),order.end());
        output<<order[order.size()-1];
        for(int i=order.size()-2;i>=0;i--)
        {
            output<<" "<<order[i];
        }
        order.clear();
        for(int i=mid+1;i<=n;i++)
        {
            order.push_back(range(mt));
        }
        sort(order.begin(),order.end());
        for(int i=order.size()-1;i>=0;i--)
        {
            output<<" "<<order[i];
        }
        return;
    }
    if(mode==1)
    {
        vector<int> order={};
        for(int i=1;i<=n;i++)
        {
            order.push_back(dist(mt));
        }
        sort(order.begin(),order.end());
        output<<order[order.size()-1];
        for(int i=order.size()-2;i>=0;i--)
        {
            output<<" "<<order[i];
        }
        return;
    }
}
int main()
{
    ofstream output;
    int sub,st,en,n=1000000,lim=1000000;
    //ios_base::sync_with_stdio(false);
    //cin.tie(0);
    cout<<"Subtask: ";
    cin>>sub;
    cout<<"From: ";
    cin>>st;
    cout<<"To: ";
    cin>>en;
    //Modes: 1=descending, 2=half-descends, 3=valley-mountain, 4=heaven-hell, 5=equal-start-end, 6=full-random
    for(int f=st;f<=en;f++)
    {
        string filename = "ropes.";
        filename+=((f/10)+'0');
        filename+=((f%10)+'0');
        filename+=".in";
        output.open(filename);
        output<<"6\n";//mode-count * test-per-mode
        if(sub==1){n=200;lim=1000000;}
        if(sub==2){n=5000;lim=1000000;}
        if(sub==3){n=100000;lim=1000000;}
        if(sub==4){n=1000000;lim=2;}
        if(sub==5){n=1000000;lim=1000000;}

        output<<n<<"\n";
        gen_test(n,lim,output,1);
        output<<"\n";

        output<<n<<"\n";
        gen_test(n,lim,output,2);
        output<<"\n";

        output<<n<<"\n";
        gen_test(n,lim,output,3);
        output<<"\n";

        output<<n<<"\n";
        gen_test(n,lim,output,4);
        output<<"\n";

        output<<n<<"\n";
        gen_test(n,lim,output,5);
        output<<"\n";

        output<<n<<"\n";
        gen_test(n,lim,output,6);

        output.close();
    }
}
/*
Subtasks
1: 2 tests (1-2)
2: 3 tests (3-5)
3: 7 tests (6-12)
4: 3 tests (13-15)
5: 5 tests (16-20)
*/
