#include <iostream>
#include <iomanip>
#include <cmath>
#include <vector>

const int MAX_N = 1e6;
const int MAX_H = 1e6;

int n;
int h[MAX_N];

double ans;

void input()
{
    std::cin >> n;
    for (int i = 0; i < n; i++)
    {
        std::cin >> h[i];
    }
}

void output()
{
    std::cout << std::setprecision(6) << std::fixed << ans << std::endl;
}

long long prefSums[MAX_N + 1];

std::vector<long long> cntSort[MAX_H + 1];

void solve()
{
    for (int curr = 1; curr <= MAX_H; curr++)
    {
        cntSort[curr].clear();
    }

    prefSums[0] = h[0];
    for (int i = 0; i < n; i++)
    {
        int nextH = i < n - 1 ? h[i + 1] : 0;
        prefSums[i + 1] = prefSums[i] + 1 + std::abs(nextH - h[i]);
    }

    ans = prefSums[n];

    for (int i = n - 1; i >= 0; i--)
    {
        cntSort[h[i]].push_back(i);
    }

    int maxI = -1;

    for (int curr = MAX_H; curr >= 1; curr--)
    {
        for (int i : cntSort[curr])
        {
            maxI = std::max(maxI, i);

            if (i < maxI)
            {
                long long x = maxI - i;
                long long y = h[maxI] - curr;

                double rope = std::sqrt(x * x + y * y);
                double dist = prefSums[i] + prefSums[n] - prefSums[maxI] + rope;

                ans = std::min(ans, dist);
            }
        }
    }
}

int main()
{
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);

    int t;
    std::cin >> t;
    for (int i = 0; i < t; i++)
    {
        input();
        solve();
        output();
    }

    return 0;
}
