#include <iostream>
#include <iomanip>
#include <cmath>
#include <vector>

const int MAX_H = 1e6;

int n;
std::vector<int> h;

double ans;

void input()
{
    h.clear();
    std::cin >> n;
    for (int i = 0; i < n; i++)
    {
        int a;
        std::cin >> a;
        h.push_back(a);
    }
}

void output()
{
    std::cout << std::setprecision(6) << std::fixed << ans << std::endl;
}

void solve()
{
    std::vector<long long> prefSums;

    prefSums.push_back(h[0]);
    for (int i = 0; i < n; i++)
    {
        int nextH = i < n - 1 ? h[i + 1] : 0;
        prefSums.push_back(prefSums.back() + 1 + std::abs(nextH - h[i]));
    }

    ans = prefSums[n];

    std::vector<std::pair<int, int>> prefMins;
    std::vector<std::pair<int, int>> suffMaxs;

    int prevPrefMin = MAX_H + 1;
    for (int i = 0; i < n; i++)
    {
        if (h[i] < prevPrefMin)
        {
            prevPrefMin = h[i];
            prefMins.push_back({h[i], i});
        }
    }

    int prevSuffMax = 0;
    for (int i = n - 1; i >= 0; i--)
    {
        if (h[i] > prevSuffMax)
        {
            prevSuffMax = h[i];
            suffMaxs.push_back({h[i], i});
        }
    }

    int numPrefMins = prefMins.size();
    int numSuffMaxs = suffMaxs.size();

    for (int i = 0, j = numSuffMaxs; i < numPrefMins; i++)
    {
        while (j > 0 && suffMaxs[j - 1].first >= prefMins[i].first) j--;

        if (j < numSuffMaxs && suffMaxs[j].first >= prefMins[i].first && suffMaxs[j].second > prefMins[i].second)
        {
            long long x = suffMaxs[j].second - prefMins[i].second;
            long long y = suffMaxs[j].first - prefMins[i].first;

            double rope = std::sqrt(x * x + y * y);
            double dist = prefSums[prefMins[i].second] + prefSums[n] - prefSums[suffMaxs[j].second] + rope;

            ans = std::min(ans, dist);
        }
    }
}

int main()
{
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);

    int t;
    std::cin >> t;
    for (int i = 0; i < t; i++)
    {
        input();
        solve();
        output();
    }

    return 0;
}
