#include <iostream>
#include <iomanip>
#include <cmath>

const int MAX_N = 1e6;
const int MAX_H = 1e6;

int n;
int h[MAX_N];

double ans;

void input()
{
    std::cin >> n;
    for (int i = 0; i < n; i++)
    {
        std::cin >> h[i];
    }
}

void output()
{
    std::cout << std::setprecision(6) << std::fixed << ans << std::endl;
}

long long prefSums[MAX_N + 1];

std::pair<int, int> prefMins[MAX_N];
std::pair<int, int> suffMaxs[MAX_N];

void solve()
{
    prefSums[0] = h[0];
    for (int i = 0; i < n; i++)
    {
        int nextH = i < n - 1 ? h[i + 1] : 0;
        prefSums[i + 1] = prefSums[i] + 1 + std::abs(nextH - h[i]);
    }

    ans = prefSums[n];

    int numPrefMins = 0;
    int prevPrefMin = MAX_H + 1;
    for (int i = 0; i < n; i++)
    {
        if (h[i] < prevPrefMin)
        {
            prevPrefMin = h[i];
            prefMins[numPrefMins++] = {h[i], i};
        }
    }

    int numSuffMaxs = 0;
    int prevSuffMax = 0;
    for (int i = n - 1; i >= 0; i--)
    {
        if (h[i] > prevSuffMax)
        {
            prevSuffMax = h[i];
            suffMaxs[numSuffMaxs++] = {h[i], i};
        }
    }

    for (int i = 0, j = numSuffMaxs; i < numPrefMins; i++)
    {
        while (j > 0 && suffMaxs[j - 1].first >= prefMins[i].first) j--;

        if (j < numSuffMaxs && suffMaxs[j].first >= prefMins[i].first && suffMaxs[j].second > prefMins[i].second)
        {
            long long x = suffMaxs[j].second - prefMins[i].second;
            long long y = suffMaxs[j].first - prefMins[i].first;

            double rope = std::sqrt(x * x + y * y);
            double dist = prefSums[prefMins[i].second] + prefSums[n] - prefSums[suffMaxs[j].second] + rope;

            ans = std::min(ans, dist);
        }
    }
}

int main()
{
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);

    int t;
    std::cin >> t;
    for (int i = 0; i < t; i++)
    {
        input();
        solve();
        output();
    }

    return 0;
}
