#include <iostream>
#include <fstream>
#include <iomanip>
#include <math.h>

bool isCorrect(
    const double actual,
    const double expected
) {
    const long double MAX_ERR = 1e-6L;
    long double absErr = std::abs(expected - actual);
    long double relErr = std::abs(expected - actual) / std::max(1.0, std::abs(expected));
    return std::min(absErr, relErr) <= MAX_ERR;
}

int main(int argc, char *argv[]) {
    std::ifstream in(argv[1]);
    std::ifstream out(argv[2]);
    std::ifstream sol(argv[3]);

    int t;
    in >> t;
    for (int i = 0; i < t; i ++) {
        long double a, b;
        out >> a;
        sol >> b;
        if (!isCorrect(a, b)) {
            std::cout << 0 << std::endl;
            return 0;
        }
    }

    std::cout << 1 << std::endl;

    return 0;
}
