#include <algorithm>
#include <cassert>
#include <iostream>
#include <numeric>
#include <vector>

typedef long long llong;
const int MAXN = 2000 + 10;
const int INF = 1e9;

int n, m, r, c;
int h[2 * MAXN];
bool t[2 * MAXN][2 * MAXN];
int suffMIN[2 * MAXN];
char s[MAXN];

int findMaxInHistogram() {
    int min = n;
    int ans = 0;
    suffMIN[m + 1] = n;
    for (int i = m; i >= 1; --i) {
        suffMIN[i] = suffMIN[i + 1];
        suffMIN[i] = std::min(suffMIN[i], h[i]);
    }
    for (int i = 1; i <= m; ++i) {
        min = std::min(min, h[i]);
        if (h[i] == 0) {
            continue;
        }

        int l = i;
        int r = i;
        if (h[i] != min) {
            while (l > 1 && h[i] <= h[l - 1])
                l--;
        } else {
            l = 1;
        }

        if (h[i] != suffMIN[i]) {
            while (r < m && h[i] < h[r + 1])
                r++;
        } else {
            r = m;
        }

        ans = std::max(ans, h[i] * (r - l + 1));
    }

    return ans;
}

bool col[2 * MAXN];
bool row[2 * MAXN];
void solve() {
    for (int i = 1; i <= 2 * n; ++i) {
        row[i] = 1;
    }

    for (int i = 1; i <= 2 * m; ++i) {
        col[i] = 1;
    }

    llong ans = 0;
    int newN = (r == 1 ? n : 2 * n);
    int newM = (c == 1 ? m : 2 * m);

    for (int i = 1; i <= newN; ++i) {
        for (int j = 1; j <= newM; ++j) {
            if (i <= n && j <= m) {
                continue;
            }

            t[i][j] = t[(i <= n ? i : i - n)][(j <= m ? j : j - m)];
        }
    }

    int oldN = n;
    int oldM = m;
    n = newN;
    m = newM;

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= m; ++j) {
            row[i] &= t[i][j];
            col[j] &= t[i][j];
        }
    }

    bool allOnes = true;
    for (int i = 1; i <= n; ++i)
        allOnes &= row[i];
    for (int i = 1; i <= m; ++i)
        allOnes &= col[i];
    if (allOnes) {
        std::cout << 1LL * oldN * oldM * r * c << '\n';
        return;
    }

    int last = 0;
    for (int i = 1; i <= n; ++i) {
        if (row[i]) {
            ans = std::max(ans, 1LL * oldM * c * (i - last));
        } else {
            last = i;
        }
    }

    last = 0;
    for (int i = 1; i <= m; ++i) {
        if (col[i]) {
            ans = std::max(ans, 1LL * oldN * r * (i - last));
        } else {
            last = i;
        }
    }

    for (int i = 1; i <= n; ++i) {
        for (int j = 1; j <= m; ++j) {
            if (t[i][j])
                h[j]++;
            else
                h[j] = 0;
        }

        ans = std::max(ans, (llong)findMaxInHistogram());
    }

    std::cout << ans << '\n';
}

void input() {
    std::cin >> n >> m >> r >> c;
    for (int i = 1; i <= n; ++i) {
        std::cin >> s;
        for (int j = 1; j <= m; ++j) {
            t[i][j] = (s[j - 1] == '1');
        }
    }
}

void fastIOI() {
    std::ios_base ::sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main() {
    fastIOI();
    input();
    solve();

    return 0;
}