// subtask8_static_fixed.cpp
#include <bits/stdc++.h>
using namespace std;
const int64_t MAXN = 4005;
const int64_t MAXM = 4005;
char a[MAXN][MAXM];
int64_t colFull[MAXM], rowFull[MAXN];
int64_t BIG_N, BIG_M;

int64_t largestRectangleInHistogram(vector<int64_t>& h) {
    stack<int64_t> s;
    h.push_back(0); // sentinel
    int64_t maxArea = 0;
    for (int64_t i = 0; i < h.size(); i++) {
        while (!s.empty() && h[i] < h[s.top()]) {
            int64_t height = h[s.top()];
            s.pop();
            int64_t width = s.empty() ? i : i - s.top() - 1;
            maxArea = max(maxArea, height * width);
        }
        s.push(i);
    }
    return maxArea;
}

int64_t maximalRectangle() {
    vector<int64_t> height(BIG_M, 0);
    int64_t maxArea = 0;

    for (int64_t i = 0; i < BIG_N; i++) {
        for (int64_t j = 0; j < BIG_M; j++) {
            height[j] = (a[i][j] == '1') ? height[j] + 1 : 0;
        }
        maxArea = max(maxArea, largestRectangleInHistogram(height));
    }
    return maxArea;
}

signed main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int64_t N, M;
    int64_t R, C;
    if (!(cin >> N >> M >> R >> C))
        return 0;
    for (int64_t i = 0; i < N; i++)
        cin >> a[i];

    BIG_N = std::min(static_cast<int64_t>(2), R) * N;
    BIG_M = std::min(static_cast<int64_t>(2), C) * M;

    for (int64_t i = 0; i < BIG_N; i++) {
        for (int64_t j = 0; j < BIG_M; j++) {
            a[i][j] = a[i % N][j % M];
        }
    }

    int64_t best = (int64_t)maximalRectangle();

    for (int64_t j = 0; j < M; j++) {
        int64_t ok = 1;
        for (int64_t i = 0; i < N; i++)
            if (a[i][j] != '1') {
                ok = 0;
                break;
            }
        colFull[j] = ok;
    }
    for (int64_t i = 0; i < N; i++) {
        int64_t ok = 1;
        for (int64_t j = 0; j < M; j++)
            if (a[i][j] != '1') {
                ok = 0;
                break;
            }
        rowFull[i] = ok;
    }

    int64_t bestCols = 0;
    if (M > 0) {
        int64_t cur = 0;
        for (int64_t j = 0; j < BIG_M; j++) {
            if (colFull[j % M]) {
                cur++;
                if (cur > bestCols)
                    bestCols = cur;
            } else
                cur = 0;
        }
        if (bestCols > M)
            bestCols = M;
    }

    int64_t bestRows = 0;
    if (N > 0) {
        int64_t cur = 0;
        for (int64_t i = 0; i < BIG_N; i++) {
            if (rowFull[i % N]) {
                cur++;
                if (cur > bestRows)
                    bestRows = cur;
            } else
                cur = 0;
        }
        if (bestRows > N)
            bestRows = N;
    }

    if (bestCols > 0) {
        int64_t area = (int64_t)bestCols * (int64_t)N * (int64_t)R;
        if (area > best)
            best = area;
    }
    if (bestRows > 0) {
        int64_t area = (int64_t)bestRows * (int64_t)M * (int64_t)C;
        if (area > best)
            best = area;
    }
    if (bestCols == M && bestRows == N) {
        int64_t area = (int64_t)N * (int64_t)R * (int64_t)M * (int64_t)C;
        if (area > best)
            best = area;
    }

    cout << best << '\n';
    return 0;
}
