#include<iostream>
#include<assert.h>
#define MAXN 2000000
using namespace std;
const int mod=1e9+7;
int p[MAXN+1],cnt[MAXN+1];
long long int fact[MAXN+1],inv[MAXN+1];
long long int pow (int base, int power) {
    if (power==0) return 1;
    if (power%2!=0) return (pow(base,power-1)*base)%mod;
    long long int half=pow(base,power/2);
    return (half*half)%mod;
}
void comb (long long int& last, int n, int k) {
    last*=inv[k]; last%=mod;
    last*=(n-(k-1)); last%=mod;
}
int main () {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n;
    assert(cin >> n );
    assert((1<=n)&&(n<=MAXN));
    for (int i=0; i<n; i++) {
        assert(cin >> p[i] );
        assert((1<=p[i])&&(p[i]<=n));
        //assert(p[i]<=2);
    }
    char temp;
    assert(!(cin >> temp ));
    fact[0]=1;
    for (int i=1; i<=n; i++) {
        fact[i]=fact[i-1]*i;
        fact[i]%=mod;
    }
    long long int curr=pow(fact[n],mod-2);
    for (int i=n; i>=1; i--) {
        inv[i]=curr*fact[i-1];
        inv[i]%=mod;
        curr*=i; curr%=mod;
    }
    for (int i=0; i<n; i++) {
        cnt[p[i]]++;
    }
    long long int ans=0;
    for (int i=1; i<=n; i++) {
        //assert(cnt[i]<=2);
        int other=1;
        long long int comb1=1,comb2=1;
        for (int curr=1; curr<=cnt[i]; curr++) {
            comb(comb1,cnt[i],curr);
            ans+=comb1*other;
            ans%=mod;
            if (comb2>0) {
                comb(comb2,n-cnt[i],curr);
                other+=comb2;
                other%=mod;
            }
        }
    }
    cout << ans ;
    cout << endl ;
    return 0;
}
