#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

#pragma GCC optimize ("O3")
#pragma GCC target ("sse4")

typedef long long llong;
const int MAXN = 2e6 + 10;
const int MOD  = 1e9 + 7;

int n;
int p[MAXN];
int fact[MAXN];
int ifact[MAXN];
int cnt[MAXN];

const int BUFF_SIZE = 1 << 20;
char buff[BUFF_SIZE];
int buffPos = BUFF_SIZE-1;

inline void readChar() 
{
    if (++buffPos == BUFF_SIZE) fread(buff, BUFF_SIZE, 1, stdin), buffPos = 0;
}

inline void readInt(int &num) 
{
    num = 0;
    for (; '0' > buff[buffPos] || buff[buffPos] > '9' ; readChar());
    for (; '0' <= buff[buffPos] && buff[buffPos] <= '9' ; readChar())
    {
        num = 10*num + buff[buffPos]-'0';
    }
}

int power(int num, int base)
{
    if (base == 0)
    {
        return 1;
    }

    if (base & 1)
    {
        return (1LL * num * power(num, base - 1)) % MOD;
    }

    int res = power(num, base >> 1);
    return (1LL * res * res) % MOD;
}

inline int choose(int n, int k)
{
    if (k > n) return 0;
    return (((1LL * fact[n] * ifact[k]) % MOD) * ifact[n - k]) % MOD;
}

void solve()
{
    fact[0] = 1;
    ifact[0] = 1;
    for (int i = 1 ; i <= n ; ++i)
    {
        fact[i] = (1LL * fact[i - 1] * i) % MOD;
        ifact[i] = power(fact[i], MOD - 2);
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        cnt[p[i]]++;
    }

    int answer = 0;
    for (int i = 1 ; i <= n ; ++i)
    {
        int sum = 1;
        for (int j = 1 ; j <= cnt[i] ; ++j)
        {
            answer = (answer + 1LL * choose(cnt[i], j) * sum) % MOD;
            sum += choose(n - cnt[i], j);
            if (sum >= MOD) sum %= MOD;
        }
    }

    std::cout << answer << '\n';
}

void input()
{
    readInt(n);
    for (int i = 1 ; i <= n ; ++i)
    {
        readInt(p[i]);
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    input();
    solve();

    return 0;
}