#include <bits/stdc++.h>

typedef long long ll;
const ll mod = 1e9 + 7;

const ll MAX_N = 2e6 + 10;
ll n;
ll count[MAX_N];
ll perm[MAX_N];

ll fpow(const ll x, const ll p) {
    if (p == 0) {
        return 1;
    }
    ll ans = fpow(x, p / 2);
    ans = ans * ans % mod;
    if (p & 1) {
        return ans * x % mod;
    } else {
        return ans;
    }
}

ll comb(const ll k, const ll n) {
    if (k > n) {
        return 0;
    }
    return perm[n] * fpow(perm[k], mod - 2) % mod * fpow(perm[n - k], mod - 2) % mod;
}

signed main() {
    perm[0] = 1;
    for (ll i = 1; i < MAX_N; i ++) {
        perm[i] = perm[i - 1] * i % mod;
    }

    std::cin >> n;
    for (ll i = 0; i < n; i ++) {
        ll k;
        std::cin >> k;
        count[k] ++;
    }

    ll ans = 0;

    for (ll i = 1; i <= n; i ++) {
        ll pref = 1;
        for (ll j = 1; j <= count[i]; j ++) {
            ans = (ans + comb(j, count[i]) * pref % mod) % mod;
            pref = (pref + comb(j, n - count[i])) % mod;
        }
    }

    std::cout << ans << std::endl;

    return 0;
}
