#include <bits/stdc++.h>

typedef long long ll;
const ll mod = 1e9 + 7;

const ll MAX_N = 2e6 + 10;
ll n;
int count[MAX_N];
int perm[MAX_N], inv[MAX_N];

ll fpow(const ll x, const ll p) {
    if (p == 0) {
        return 1;
    }
    ll ans = fpow(x, p / 2);
    ans = ans * ans % mod;
    if (p & 1) {
        return ans * x % mod;
    } else {
        return ans;
    }
}

signed main() {
    std::cin.tie(NULL);
    std::ios_base::sync_with_stdio(false);

    std::cin >> n;
    for (ll i = 0; i < n; i ++) {
        ll k;
        std::cin >> k;
        count[k] ++;
    }

    perm[0] = 1;
    for (ll i = 1; i <= n; i ++) {
        perm[i] = perm[i - 1] * i % mod;
    }

    inv[n] = fpow(perm[n], mod - 2);
    for (ll i = n - 1; i >= 0; i --) {
        inv[i] = inv[i + 1] * (i + 1) % mod;
    }

    ll ans = 0;

    for (ll i = 1; i <= n; i ++) {
        ll pref = 1;

        ll now = count[i];
        ll rest = n - count[i];

        ll comb_now = 1;
        ll comb_rest = 1;

        ll bound = std::min(rest, now);

        for (ll j = 1; j <= bound; j ++) {
            comb_now = comb_now * perm[j - 1] % mod * inv[j] % mod * (ll)(now - j + 1) % mod;
            comb_rest = comb_rest * perm[j - 1] % mod * inv[j] % mod * (ll)(rest - j + 1) % mod;
            ans = (ans + comb_now * pref) % mod;
            pref = (pref + comb_rest) % mod;
        }

        for (ll j = bound + 1; j <= now; j ++) {
            comb_now = comb_now * perm[j - 1] % mod * inv[j] % mod * (ll)(now - j + 1) % mod;
            ans = (ans + comb_now * pref) % mod;
        }
    }

    std::cout << ans << std::endl;

    return 0;
}
