#include<iostream>
#define MAXN 2000000
using namespace std;
const int mod=1e9+7;
int cnt[MAXN+1];
long long int fact[MAXN+1],inv[MAXN+1];
long long int pow (int base, int power) {
    if (power==0) return 1;
    if (power%2!=0) return (pow(base,power-1)*base)%mod;
    long long int half=pow(base,power/2);
    return (half*half)%mod;
}
long long int comb (int n, int k) {
    if (k>n) return 0;
    return (((fact[n]*inv[k])%mod)*inv[n-k])%mod;
}
int main () {
    ios_base::sync_with_stdio(false);
    cin.tie(NULL);
    int n;
    cin >> n ;
    for (int i=0; i<n; i++) {
        int num;
        cin >> num ;
        cnt[num]++;
    }
    fact[0]=1;
    for (int i=1; i<=n; i++) {
        fact[i]=fact[i-1]*i;
        fact[i]%=mod;
    }
    inv[n]=pow(fact[n],mod-2);
    for (int i=n-1; i>=0; i--) {
        inv[i]=inv[i+1]*(i+1);
        inv[i]%=mod;
    }
    long long int ans=0;
    for (int i=1; i<=n; i++) {
        int other=0;
        for (int curr=1; curr<=cnt[i]; curr++) {
            other+=comb(n-cnt[i],curr-1);
            other%=mod;
            ans+=comb(cnt[i],curr)*other;
            ans%=mod;
        }
    }
    cout << ans ;
    cout << endl ;
    return 0;
}
