// subtask2_fixed_majority.cpp
// Brute-force correct for N <= 20:
// counts subsequences (non-empty) and checks majority condition:
// an element v is a majority in the subsequence iff cnt[v] > (subseq_len - cnt[v])
#include <bits/stdc++.h>
using namespace std;
using ll = long long;
const int MOD = 1'000'000'007;

int main(){
    ios::sync_with_stdio(false);
    cin.tie(nullptr);
    int N;
    if(!(cin >> N)) return 0;
    vector<int> P(N);
    for(int i=0;i<N;++i) cin >> P[i];

    // compress values to 0..D-1
    vector<int> vals = P;
    sort(vals.begin(), vals.end());
    vals.erase(unique(vals.begin(), vals.end()), vals.end());
    int D = (int)vals.size();
    vector<int> A(N);
    for(int i=0;i<N;++i) A[i] = int(lower_bound(vals.begin(), vals.end(), P[i]) - vals.begin());

    ll ans = 0;
    int LIM = 1<<N;
    vector<int> cnt(D);

    // iterate all non-empty masks
    for(int mask = 1; mask < LIM; ++mask){
        // reset counts
        fill(cnt.begin(), cnt.end(), 0);
        int sz = 0;
        // count frequencies in this subsequence
        for(int i=0;i<N;++i) if(mask & (1<<i)){ cnt[A[i]]++; sz++; }

        // find maximum frequency
        int maxv = 0;
        for(int v=0; v<D; ++v) if(cnt[v] > maxv) maxv = cnt[v];

        // majority check: maxv > sz - maxv  <=>  maxv * 2 > sz
        if(maxv * 2 > sz) ans = (ans + 1) % MOD;
    }

    cout << ans % MOD << "\n";
    return 0;
}
