#include <algorithm>
#include <iostream>
#include <numeric>
#include <cassert>
#include <vector>

typedef long long llong;
const int MAXN = 2e6 + 10;
const int MOD  = 1e9 + 7;

int n;
int p[MAXN];
int fact[MAXN];
int ifact[MAXN];
int cnt[MAXN];
int cntBigger[MAXN];

int power(int num, int base)
{
    if (base == 0)
    {
        return 1;
    }

    if (base & 1)
    {
        return (1LL * num * power(num, base - 1)) % MOD;
    }

    int res = power(num, base >> 1);
    return (1LL * res * res) % MOD;
}

inline int choose(int n, int k)
{
    if (k > n) return 0;
    return (((1LL * fact[n] * ifact[k]) % MOD) * ifact[n - k]) % MOD;
}

void solve()
{
    fact[0] = 1;
    for (int i = 1 ; i <= n ; ++i)
    {
        fact[i] = (1LL * fact[i - 1] * i) % MOD;
    }

    ifact[n] = power(fact[n], MOD - 2);
    for (int i = n - 1 ; i >= 0 ; --i)
    {
        ifact[i] = (1LL * (i + 1) * ifact[i + 1]) % MOD;
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        cnt[p[i]]++;
    }

    for (int i = 1 ; i <= n ; ++i)
    {
        if (cnt[i] > 0) cntBigger[cnt[i] - 1]++;
    }

    for (int i = n ; i >= 0 ; --i)
    {
        cntBigger[i] += cntBigger[i + 1];
    }

    int answer = 0;
    for (int i = 0 ; i < n ; ++i)
    {
        answer = (answer + 1LL * choose(n, i) * cntBigger[i]) % MOD;
    }


    std::cout << answer << '\n';
}

void input()
{
    std::cin >> n;
    for (int i = 1 ; i <= n ; ++i)
    {
        std::cin >> p[i];
    }
}

void fastIOI()
{
    std::ios_base :: sync_with_stdio(0);
    std::cout.tie(nullptr);
    std::cin.tie(nullptr);
}

int main()
{
    fastIOI();
    input();
    solve();

    return 0;
}