#include <iostream>
#include <algorithm>
#include <vector>
#include <set>
#include <cmath>
#include <cstring>
#define endl '\n'
using namespace std;
long long n,k;
const int maxn = 4e6;
long long a[maxn];
long long ans[maxn];
long long used[maxn*4];
long long treeor[maxn*4];
long long treeand[maxn*4];
void updateand(int v, int l, int r, int ql, int qr, long long val) {
    if(l>qr || r<ql) return;
    if(l>=ql && r<=qr) {
        treeand[v]&=val;
        return;
    }
    int mid = (l+r)/2;
    updateand(v*2, l, mid, ql, qr, val);
    updateand(v*2+1, mid+1, r, ql, qr, val);
    treeand[v]=treeand[v*2]&treeand[v*2+1];
}
long long queryand(int v, int l, int r, int ql, int qr) {
    if(l>qr || r<ql) return (1LL<<k)-1;
    if(l>=ql && r<=qr) return treeand[v];
    int mid = (l+r)/2;
    return queryand(v*2, l, mid, ql, qr)&queryand(v*2+1, mid+1, r, ql, qr);
}
void updateor(int v, int l, int r, int ql, int qr, long long val) {
    if(l>qr || r<ql) return;
    if(l>=ql && r<=qr) {
        treeor[v]|=val;
        return;
    }
    int mid = (l+r)/2;
    updateor(v*2, l, mid, ql, qr, val);
    updateor(v*2+1, mid+1, r, ql, qr, val);
    treeor[v]=treeor[v*2]|treeor[v*2+1];
}
long long queryor(int v, int l, int r, int ql, int qr) {
    if(l>qr || r<ql) return 0;
    if(l>=ql && r<=qr) return treeor[v];
    int mid = (l+r)/2;
    return queryor(v*2, l, mid, ql, qr)|queryor(v*2+1, mid+1, r, ql, qr);
}
int binl(int m) {
    // max value where queryor(mid,m)==2^k-1
    int l = 1, r = m, mid, ans=-1;
    while(l<=r) {
        mid = (l+r)/2;
        if(queryor(1, 1, n, mid, m)==(1LL<<k)-1) {
            ans = mid;
            l = mid + 1;
        }
        else r = mid - 1;
    }
    return ans;
}
int binr(int m) {
    // min value where queryand(m+1, mid)==0
    int l = m+1, r = n, mid, ans=-1;
    while(l<=r) {
        mid = (l+r)/2;
        if(queryand(1, 1, n, m+1, mid)==0) {
            ans = mid;
            r = mid - 1;
        }
        else l = mid + 1;
    }
    return ans;
}
int main() {
    ios::sync_with_stdio(false);
    cin.tie(0);
    cout.tie(0);
    cin >> n >> k;
    for(int i = 0; i <= maxn*3; i++) {
        treeand[i]=(1LL<<k)-1;
    }
    for(int i = 1; i <= n; i++) {
        cin >> a[i];
        updateor(1,1,n,i,i,a[i]);
        updateand(1,1,n,i,i,a[i]);
    }
    int br = 0;
    for(int m = 1; m <= n; m++) {
        int mnl=binl(m),mnr=binr(m);
        if(mnr==-1||mnl==-1) continue;
        if(!used[mnl]) for(int l = 1; l <= mnl; l++) {
            ans[l]=max(ans[l], n-mnr+1);
        }
        used[mnl]=1;
    }
    for(int i = 1; i <= n; i++) {
        br+=ans[i];
    }
    cout<<br;
}
