#include <bits/stdc++.h>
using namespace std;
#define int long long

vector<int> memo;

vector<int> parents;
vector<vector<int>> childs;
vector<int> results;
vector<int> for_update;
int n, q;
int res = 0;

void getChilds()
{
    childs.clear();
    childs.resize(n + 1, vector<int>());
    for(int i = 2;i <= n;i++)
    {
        childs[parents[i]].push_back(i);
    }
}

int getPerformance()
{
    for(int i = 1; i <= n; i++)
    {
        memo[i] = 0;
    }

    res = 0;
    for(int i = 1; i <= n; i++)
    {
        int nxt = i;
        int r = 0;
        while(nxt != 1 && memo[nxt] == 0)
        {
            nxt = parents[nxt];
            r++;
        }
        r += memo[nxt];

        nxt = i;
        while(nxt != 1 && memo[nxt] == 0)
        {
            memo[nxt] = r;
            nxt = parents[nxt];
            r--;
        }
    }

    for(int i = 1; i <= n; i++)
    {
        res += memo[i];
    }
    //cout << "co" << endl;
    return res;
}

int getPerformance(int joint)
{
    getChilds();
    vector<int> for_update;
    int joint_performance = 0;

    int nxt = joint;
    while(nxt != 1)
    {
        nxt = parents[nxt];
        joint_performance++;
    }

    joint_performance -= memo[joint];

    queue<int> q;
    q.push(joint);
    while(q.size() > 0)
    {
        int tp = q.front();
        q.pop();

        memo[tp] += joint_performance;
        for_update.push_back(tp);
        for(int i : childs[tp])
        {
            q.push(i);
        }
    }

    res += for_update.size() * joint_performance;
    return res;
}

void upgrade(int p, int c)
{
    int next_maneger = c;

    while(next_maneger != p)
    {
        int x = parents[next_maneger];
        parents[next_maneger] = p;
        next_maneger = x;
        //cout << x << endl;
    }
    //cout << "up" << endl;
}

int getPerformanceBFS()
{
    getChilds();
    queue<pair<int, int>> q;
    q.push({1, 0});
    int res = 0;
    while(q.size() > 0)
    {
        pair<int, int> tp = q.front();
        q.pop();

        res += tp.second;
        for(int i : childs[tp.first])
        {
            q.push({i, tp.second + 1});
        }
    }

    return res;
}

int32_t main()
{
    ios_base::sync_with_stdio(0);
    cin.tie(0);
    cout.tie(0);

    cin >> n >> q;

    parents.resize(n + 1, 1);

    for(int i = 1; i < n; i++)
    {
        int u, v;
        cin >> u >> v;
        parents[v] = u;
    }

    for(int i = 0; i < q; i++)
    {
        int p, c;
        cin >> p >> c;

        upgrade(p, c);
        results.push_back(getPerformanceBFS());
    }

    for(int i : results)
    {
        cout << i << endl;
    }
}

