#include <bits/stdc++.h>
long long oriand(int n, int k, std::vector<long long> a)
{
    long long mask = (1ll << k) - 1;

    int maxLevel = 0;
    while ((1 << (maxLevel + 1)) <= n)
    {
        maxLevel++;
    }

    long long orRight;
    long long andRight;
    std::vector<long long> orStack;
    std::vector<long long> andStack;

    auto pushOr = [&](int i)
    {
        orRight = orRight | a[i];
    };

    auto pushAnd = [&](int i)
    {
        andRight = andRight & a[i];
    };

    auto popOr = [&]()
    {
        if (orStack.empty()) return;
        orStack.pop_back();
    };

    auto popAnd = [&]()
    {
        if (andStack.empty()) return;
        andStack.pop_back();
    };

    auto getOr = [&](int l, int r) -> long long
    {
        if (orStack.empty())
        {
            orRight = 0;
            orStack.push_back(0);
            for (int i = r; i >= l; i--)
            {
                orStack.push_back(orStack.back() | a[i]);
            }
        }

        return orRight | orStack.back();
    };

    auto getAnd = [&](int l, int r) -> long long
    {
        if (andStack.empty())
        {
            andRight = mask;
            andStack.push_back(mask);
            for (int i = r; i >= l; i--)
            {
                andStack.push_back(andStack.back() & a[i]);
            }
        }

        return andRight & andStack.back();
    };

    long long ans = 0;
    for (int l = 0, m = -1, r = -1; l < n; l++)
    {
        if (l > 0)
        {
            popOr();
        }

        while (m < n && (m < l || getOr(l, m) != mask))
        {
            m++;
            if (m < n)
            {
                popAnd();
                pushOr(m);
            }
        }

        if (m == n) break;

        while (r < n && (r < m + 1 || getAnd(m + 1, r) != 0))
        {
            r++;
            if (r < n)
            {
                pushAnd(r);
            }
        }

        if (r == n) break;

        ans += n - r;
    }

    return ans;
}

int main() {
    std::ios::sync_with_stdio(false);
    std::cin.tie(nullptr);

    int n, k;
    std::cin >> n >> k;
    std::vector<long long> v(n);
    for (int i = 0; i < n; i++) {
        std::cin >> v[i];
    }

    std::cout << oriand(n, k, v) << "\n";

    return 0;
}