#include <iostream>
#include <vector>

using namespace std;

const int MAXN = 1000000;
long long TARGET_OR;

int calc_or(const vector<long long>& v, int start) {
    long long curr = 0;
    for (int i = start; i < v.size(); i++) {
        curr |= v[i];
        if (curr == TARGET_OR) return i;
    }
    return v.size();
}

int calc_and(const vector<long long>& v, int start) {
    long long curr = TARGET_OR;
    for (int i = start; i < v.size(); i++) {
        curr &= v[i];
        if (curr == 0) return i;
    }
    return v.size();
}


long long oriand(int n, int k, vector<long long> v) {
    TARGET_OR = (1ULL<<k)-1;

    long long ans = 0;
    for (int l = 0; l < v.size(); l++) {
        int m = calc_or(v, l);
        int r = calc_and(v, m+1);

        ans += (v.size()-r);

        //cout << l << " " << m << " " << r << endl;
    }
    return ans;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, k;
    cin >> n >> k;
    vector<long long> v(n);
    for (int i = 0; i < n; i++) {
        cin >> v[i];
    }

    cout << oriand(n, k, v) << "\n";

    return 0;
}