#include <iostream>
#include <vector>

using namespace std;

const int MAXN = 1000000;
long long k;
long long TARGET_OR;

long long a[MAXN+1];
int end_or[MAXN];
int end_and[MAXN];
int br[64];

void change(long long x, int diff) {
    for (int i = 0; i < k; i++) {
        br[i] += x%2*diff;
        x /= 2;
    }
}

long long getOr() {
    long long ans = 0;
    for (int i = 0; i < k; i++) {
        if (br[i]) ans |= (1ULL<<i);
    }
    return ans;
}

long long getAnd(int len) {
    long long ans = TARGET_OR;
    for (int i = 0; i < k; i++) {
        if (br[i] != len) ans ^= (1ULL<<i);
    }
    return ans;
}

void calcOr(int n) {
    int l = 0;
    int r = -1;
    for (int i = 0; i < n; i++) {
        while (r < n && getOr() != TARGET_OR) {
            change(a[++r], 1);
        }
        end_or[i] = r;
        change(a[l++], -1);
    }
}

void calcAnd(int n) {
    int l = 0;
    int r = -1;
    for (int i = 0; i < n; i++) {
        while (r < n && getAnd(r-l+1) != 0) {
            change(a[++r], 1);
        }
        end_and[i] = r;
        change(a[l++], -1);
    }
}


long long oriand(int n, int kk, vector<long long> v) {
    k = kk;
    TARGET_OR = (1ULL<<k)-1;

    for (int i = 0; i < n; i++) a[i] = v[i];

    calcOr(n);
    calcAnd(n);

    //for (int i = 0; i < n; i++) cout << end_or[i] << " "; cout << endl;
    //for (int i = 0; i < n; i++) cout << end_and[i] << " "; cout << endl;

    long long ans = 0;
    for (int i = 0; i < n; i++) {
        int m = end_or[i];
        int r = m+1 < n ? end_and[m+1] : n;
        ans += n-r;
    }

    return ans;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, k;
    cin >> n >> k;
    vector<long long> v(n);
    for (int i = 0; i < n; i++) {
        cin >> v[i];
    }

    cout << oriand(n, k, v) << "\n";

    return 0;
}