#include <iostream>
#include <stack>
#include <vector>

using namespace std;

long long TARGET_OR;

long long op(long a, long b, long target) {
    if (target == 0) return a&b;
    return a|b;
}

vector<int> calc(int n, const vector<long long>& v, long long target) {
    vector<int> ans(n);

    int r = -1;
    stack<long> st;
    st.push(TARGET_OR-target);
    long long curr = TARGET_OR-target;
    for (int i = 0; i < n; i++) {
        while (r < n && op(st.top(), curr, target) != target) {
            r++;
            if (r < n) {
                curr = op(curr, v[r], target);
            }
        }
        if (st.size() == 1 && r < n) {
            curr = TARGET_OR-target;
            for (int j = r; j >= i; j--) {
                st.push(op(st.top(),v[j],target));
            }
        }

        ans[i] = r;
        if (r < n) st.pop();
    }
    return ans;
}

long long oriand(int n, int k, vector<long long> v) {
    TARGET_OR = (1ULL<<k)-1;

    vector<int> endOr = calc(n, v, TARGET_OR);
    vector<int> endAnd = calc(n, v, 0);

    long long ans = 0;
    for (int i = 0; i < n; i++) {
        int m = endOr[i];
        int r = m+1 < n ? endAnd[m+1] : n;
        ans += n-r;
    }
    return ans;
}

int main() {
    ios::sync_with_stdio(false);
    cin.tie(nullptr);

    int n, k;
    cin >> n >> k;
    vector<long long> v(n);
    for (int i = 0; i < n; i++) {
        cin >> v[i];
    }

    cout << oriand(n, k, v) << "\n";

    return 0;
}