# include <bits/stdc++.h>
using namespace std;

int n, q;
const int MAXN = 1e5 + 5;
set <int> g[MAXN];
int par[MAXN];
void dfs_initial(int v, int p = -1) {
	par[v] = p;
	g[v].erase(p);
	for (int u : g[v]) {
		dfs_initial(u, v);
	}
}

pair<int, long long> dfs(int v){
	int sz = 1;
	long long res = 0;
	for (int u : g[v]) {
		auto [sub_sz, sub_res] = dfs(u);
		sz += sub_sz;
		res += sub_res + sub_sz;
	}
	return {sz, res};
}

void move(int v, int p){
	if (par[v] != -1)
		g[par[v]].erase(v);
	g[p].insert(v);
	par[v] = p;
}

void move_path(int v, int p){
	while (par[v] != p) {
		int tmp = par[v];
		move(v, p);
		v = tmp;
	}
}

int main()
{
	ios_base::sync_with_stdio(false);
	cin.tie(nullptr);
	cout.tie(nullptr);

	cin >> n >> q;
	for (int i = 0; i < n - 1; i++) {
		int u, v;
		cin >> u >> v;
		g[u].insert(v);
		g[v].insert(u);
	}

	dfs_initial(1);

	for (int i = 0; i < q; i++) {
		int p, v;
		cin >> p >> v;
		move_path(v, p);
		auto [sz, res] = dfs(1);
		cout << res << "\n";
	}
}