#include <bits/stdc++.h>
#include "oriand.h"

using namespace std;

const int maxn=9e4+5;
long long a[maxn],check_or,check_and=0;
long long tree_or[4*maxn];
long long tree_and[4*maxn];

void build_tree_or(long long curr,long long l,long long r)
{
    if(l==r)
    {
        tree_or[curr]=a[l];
        return;
    }

    long long mid=(l+r)/2;
    build_tree_or(2*curr,l,mid);
    build_tree_or(2*curr+1,mid+1,r);

    tree_or[curr]=(tree_or[2*curr] | tree_or[2*curr+1]);
}

long long query_or(long long curr,long long l,long long r,long long ql,long long qr)
{
    if(ql<=l && r<=qr)
        return tree_or[curr];

    long long mid=(l+r)/2;
    long long left=-1,right=-1;

    if(!(l>qr || mid<ql || mid<l))
        left=query_or(2*curr,l,mid,ql,qr);
    if(!(mid+1>qr || r<ql || r<mid+1))
        right=query_or(2*curr+1,mid+1,r,ql,qr);

    if(left==-1)
        return right;
    else if(right==-1)
        return left;
    else
        return (left | right);
}

void build_tree_and(long long curr,long long l,long long r)
{
    if(l==r)
    {
        tree_and[curr]=a[l];
        return;
    }

    long long mid=(l+r)/2;
    build_tree_and(2*curr,l,mid);
    build_tree_and(2*curr+1,mid+1,r);

    tree_and[curr]=(tree_and[2*curr] & tree_and[2*curr+1]);
}

long long query_and(long long curr,long long l,long long r,long long ql,long long qr)
{
    if(ql<=l && r<=qr)
        return tree_and[curr];

    long long mid=(l+r)/2;
    long long left=-1,right=-1;

    if(!(l>qr || mid<ql || mid<l))
        left=query_and(2*curr,l,mid,ql,qr);
    if(!(mid+1>qr || r<ql || r<mid+1))
        right=query_and(2*curr+1,mid+1,r,ql,qr);

    if(left==-1)
        return right;
    else if(right==-1)
        return left;
    else
        return (left & right);
}

long long oriand(int N, int K, std::vector<long long> A)
{
    memset(a,0,sizeof(a));
    memset(tree_and,0,sizeof(tree_and));
    memset(tree_or,0,sizeof(tree_or));

    if(N==1)
        return 0;

    for(int i=0;i<A.size();i++)
        a[i+1]=A[i];
    check_or=(1<<K)-1;

    build_tree_or(1,1,N);
    build_tree_and(1,1,N);

    long long ans=0;
    for(long long l=1;l<N;l++)
    {
        for(long long r=l+1;r<=N;r++)
        {
            for(long long mid=l;mid<r;mid++)
            {
                if(query_or(1,1,N,l,mid)== (1<<K)-1 &&
                    query_and(1,1,N,mid+1,r)==0)
                {
                    //cout<<l<<' '<<mid<<' '<<r<<endl;
                    ans++;
                    break;
                }
            }
        }
    }

    return ans;
}
